/*
 * Decompiled with CFR 0.152.
 */
package cn.jque.common.base;

import cn.jque.common.enums.ResponseEnum;
import java.io.Serializable;

public class Response<T>
implements Serializable {
    private static final long serialVersionUID = 8236647872062931279L;
    private int code;
    private String message;
    private T data;
    private Integer total;

    public static <T> Response<T> success() {
        return Response.success(ResponseEnum.SUCCESS.getMessage());
    }

    public static <T> Response<T> success(String message) {
        return Response.success(message, null);
    }

    public static <T> Response<T> success(T data) {
        return Response.success(ResponseEnum.SUCCESS.getMessage(), data);
    }

    public static <T> Response<T> success(String message, T data, Integer total) {
        return Response.success(ResponseEnum.SUCCESS.getCode(), message, data, total);
    }

    public static <T> Response<T> success(String message, T data) {
        return Response.success(ResponseEnum.SUCCESS.getCode(), message, data, null);
    }

    public static <T> Response<T> success(int code, String message) {
        return Response.success(code, message, null, null);
    }

    public static <T> Response<T> success(int code, String message, T data, Integer total) {
        Response<T> result = new Response<T>();
        result.setCode(code);
        result.setMessage(message);
        result.setData(data);
        result.setTotal(total);
        return result;
    }

    public static <T> Response<T> failure() {
        return Response.failure(ResponseEnum.FAILURE.getMessage());
    }

    public static <T> Response<T> failure(String message) {
        return Response.failure(message, null);
    }

    public static <T> Response<T> failure(String message, T data) {
        return Response.failure(ResponseEnum.FAILURE.getCode(), message, data);
    }

    public static <T> Response<T> failure(int code, String message, T data) {
        Response<T> result = new Response<T>();
        result.setCode(code);
        result.setMessage(message);
        result.setData(data);
        return result;
    }

    public static <T> Response<T> failure(int code, String message) {
        return Response.failure(code, message, null);
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public Integer getTotal() {
        return this.total;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        Response other = (Response)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        Integer this$total = this.getTotal();
        Integer other$total = other.getTotal();
        if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Response;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        Integer $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "Response(code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ", total=" + this.getTotal() + ")";
    }
}

