package cn.jque.common.exception;

import cn.jque.common.enums.BaseErrorCode;
import lombok.Data;
import org.springframework.http.HttpStatus;

@Data
public class BadRequestException extends RuntimeException {

	private static final long serialVersionUID = -3047059124979695599L;

	protected HttpStatus status;
	protected BaseErrorCode error;

	public BadRequestException(HttpStatus status, BaseErrorCode error) {
		super(error == null ? null : error.getName());
		this.status = status;
		this.error = error;
	}

}
