/*
 * Decompiled with CFR 0.152.
 */
package cn.jque.common.base;

import cn.jque.common.enums.BaseErrorCode;
import cn.jque.common.enums.CommonErrorCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@ApiModel(value="\u7edf\u4e00\u54cd\u5e94\u7c7b")
public class Result<T>
implements Serializable {
    private static final long serialVersionUID = -7209448582451538499L;
    @ApiModelProperty(value="\u4e1a\u52a1\u54cd\u5e94\u662f\u5426\u6210\u529f")
    private Boolean success;
    @ApiModelProperty(value="\u4e1a\u52a1\u54cd\u5e94\u72b6\u6001\u7801")
    private Integer code = 200;
    @ApiModelProperty(value="\u4e1a\u52a1\u54cd\u5e94\u4fe1\u606f")
    private String message;
    @ApiModelProperty(value="\u4e1a\u52a1\u54cd\u5e94\u6570\u636e")
    private T data;

    public static <T> Result<T> ok() {
        return Result.of(200, true, null, null);
    }

    public static <T> Result<T> ok(T data) {
        return Result.of(200, true, null, data);
    }

    public static <T> Result<T> ok(String message) {
        return Result.of(200, true, message, null);
    }

    public static <T> Result<T> error() {
        return Result.error(CommonErrorCode.REQUEST_PARAM_ERROR.getCode(), null);
    }

    public static <T> Result<T> paramError() {
        return Result.error(CommonErrorCode.REQUEST_PARAM_ERROR.getCode(), CommonErrorCode.REQUEST_PARAM_ERROR.getName());
    }

    public static <T> Result<T> error(String message) {
        return Result.of(CommonErrorCode.REQUEST_PARAM_ERROR.getCode(), false, message, null);
    }

    public static <T> Result<T> error(int code, String message) {
        return Result.of(code, false, message, null);
    }

    public static <T> Result<T> error(BaseErrorCode error) {
        return Result.of(error.getCode(), false, error.getName(), null);
    }

    public static <T> Result<T> error(int code) {
        return Result.of(code, false, null, null);
    }

    public static <T> Result<T> of(Integer code, Boolean success, String message, T data) {
        Result<T> result = new Result<T>();
        result.setCode(code);
        result.setData(data);
        result.setMessage(message);
        result.setSuccess(success);
        return result;
    }

    public Result success(boolean success) {
        this.success = success;
        return this;
    }

    public Result code(int code) {
        this.code = code;
        return this;
    }

    public Result message(String message) {
        this.message = message;
        return this;
    }

    public Result data(T data) {
        this.data = data;
        return this;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$success = this.getSuccess();
        Boolean other$success = other.getSuccess();
        if (this$success == null ? other$success != null : !((Object)this$success).equals(other$success)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $success = this.getSuccess();
        result = result * 59 + ($success == null ? 43 : ((Object)$success).hashCode());
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "Result(success=" + this.getSuccess() + ", code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
    }
}

