/*
 * Decompiled with CFR 0.152.
 */
package cn.jsms.api.template;

import cn.jiguang.common.utils.Preconditions;
import cn.jsms.api.common.model.IModel;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class TemplatePayload
implements IModel {
    private static String TEMPLATE = "template";
    private static String TEMP_ID = "temp_id";
    private static String TTL = "ttl";
    private static String TYPE = "type";
    private static String REMARK = "remark";
    private int temp_id = -1;
    private String template;
    private int type;
    private int ttl;
    private String remark;
    private static Gson gson = new Gson();

    private TemplatePayload(int temp_id, String template, int type, int ttl, String remark) {
        this.temp_id = temp_id;
        this.template = template;
        this.type = type;
        this.ttl = ttl;
        this.remark = remark;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = new JsonObject();
        if (this.temp_id != -1) {
            json.addProperty(TEMP_ID, (Number)this.temp_id);
        }
        if (this.template != null) {
            json.addProperty(TEMPLATE, this.template);
        }
        if (this.type > 0) {
            json.addProperty(TYPE, (Number)this.type);
        }
        if (this.ttl > 0) {
            json.addProperty(TTL, (Number)this.ttl);
        }
        if (this.remark != null) {
            json.addProperty(REMARK, this.remark);
        }
        return json;
    }

    public String toString() {
        return gson.toJson(this.toJSON());
    }

    public static class Builder {
        private int tempId;
        private String template;
        private int type;
        private int ttl;
        private String remark;

        public Builder setTempId(int tempId) {
            this.tempId = tempId;
            return this;
        }

        public Builder setTemplate(String template) {
            this.template = template;
            return this;
        }

        public Builder setTTL(int ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder setType(int type) {
            this.type = type;
            return this;
        }

        public Builder setRemark(String remark) {
            this.remark = remark;
            return this;
        }

        public TemplatePayload build() {
            Preconditions.checkArgument((this.ttl >= 0 ? 1 : 0) != 0, (Object)"ttl should not less 0");
            Preconditions.checkArgument((this.type > 0 ? 1 : 0) != 0, (Object)"type should be 1, or 2 or 3");
            return new TemplatePayload(this.tempId, this.template, this.type, this.ttl, this.remark);
        }
    }
}

