/*
 * Decompiled with CFR 0.152.
 */
package cn.jsms.api.sign;

import cn.jiguang.common.utils.Preconditions;
import cn.jiguang.common.utils.StringUtils;
import cn.jsms.api.common.model.IModel;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;

public class SignPayload
implements IModel {
    private static String SIGN = "sign";
    private static String IMAGES = "images";
    private static String TYPE = "type";
    private static String REMARK = "remark";
    private String sign;
    private File[] images;
    private String remark;
    private Integer type;
    private static Gson gson = new Gson();

    public SignPayload(String sign, File[] images, String remark, Integer type) {
        this.sign = sign;
        this.images = images;
        this.remark = remark;
        this.type = type;
    }

    private SignPayload(Builder builder) {
        this.sign = builder.sign;
        this.images = builder.images;
        this.remark = builder.remark;
        this.type = builder.type;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getSign() {
        return this.sign;
    }

    public File[] getImages() {
        return this.images;
    }

    public String getRemark() {
        return this.remark;
    }

    public Integer getType() {
        return this.type;
    }

    public static String getIMAGES() {
        return IMAGES;
    }

    public static String getSIGN() {
        return SIGN;
    }

    public static String getTYPE() {
        return TYPE;
    }

    public static String getREMARK() {
        return REMARK;
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = new JsonObject();
        if (!StringUtils.isEmpty((String)this.sign)) {
            json.addProperty(SIGN, this.sign);
        }
        if (this.type != null && this.type > 0 && this.type <= 7) {
            json.addProperty(TYPE, (Number)this.type);
        }
        if (this.remark != null) {
            json.addProperty(REMARK, this.remark);
        }
        return json;
    }

    public String toString() {
        return gson.toJson(this.toJSON());
    }

    public static final class Builder {
        private String sign;
        private File[] images;
        private String remark;
        private Integer type;

        public Builder sign(String val) {
            this.sign = val;
            return this;
        }

        public Builder images(File[] val) {
            this.images = val;
            return this;
        }

        public Builder remark(String val) {
            this.remark = val;
            return this;
        }

        public Builder type(Integer val) {
            this.type = val;
            return this;
        }

        public SignPayload build() {
            Preconditions.checkArgument((!StringUtils.isEmpty((String)this.sign) && this.sign.length() >= 2 && this.sign.length() <= 8 ? 1 : 0) != 0, (Object)"sign should not be null or too long");
            Preconditions.checkArgument((this.type != null && this.type > 0 && this.type <= 7 ? 1 : 0) != 0, (Object)"type should be between 1 and 7");
            return new SignPayload(this);
        }
    }
}

