/*
 * Decompiled with CFR 0.152.
 */
package cn.jsms.api.common;

import cn.jiguang.common.ServiceHelper;
import cn.jiguang.common.connection.HttpProxy;
import cn.jiguang.common.connection.IHttpClient;
import cn.jiguang.common.connection.NativeHttpClient;
import cn.jiguang.common.connection.NettyHttpClient;
import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jiguang.common.resp.ResponseWrapper;
import cn.jiguang.common.utils.Preconditions;
import cn.jiguang.common.utils.StringUtils;
import cn.jsms.api.SendSMSResult;
import cn.jsms.api.ValidSMSResult;
import cn.jsms.api.account.AccountBalanceResult;
import cn.jsms.api.account.AppBalanceResult;
import cn.jsms.api.common.JSMSConfig;
import cn.jsms.api.common.model.BatchSMSPayload;
import cn.jsms.api.common.model.BatchSMSResult;
import cn.jsms.api.common.model.SMSPayload;
import cn.jsms.api.schedule.model.ScheduleResult;
import cn.jsms.api.schedule.model.ScheduleSMSPayload;
import cn.jsms.api.schedule.model.ScheduleSMSResult;
import cn.jsms.api.sign.SignInfoResult;
import cn.jsms.api.sign.SignPayload;
import cn.jsms.api.sign.SignResult;
import cn.jsms.api.template.SendTempSMSResult;
import cn.jsms.api.template.TempSMSResult;
import cn.jsms.api.template.TemplatePayload;
import com.google.gson.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;

public class SMSClient {
    private static String SMS_CODE = "code";
    private final String BOUNDARY = "========7d4a6d158c9";
    private String _baseUrl;
    private String _smsCodePath;
    private String _validPath;
    private String _voiceCodePath;
    private String _shortMsgPath;
    private String _schedulePath;
    private String _signPath;
    private String _signDefaultPath;
    private String _accountPath;
    private String _tempMsgPath;
    private IHttpClient _httpClient;
    private String _authCode;

    public SMSClient(String masterSecret, String appkey) {
        this(masterSecret, appkey, null, JSMSConfig.getInstance());
    }

    public SMSClient(String masterSecret, String appkey, HttpProxy proxy, JSMSConfig conf) {
        String authCode;
        ServiceHelper.checkBasic((String)appkey, (String)masterSecret);
        this._baseUrl = (String)conf.get("sms.api.host.name");
        this._smsCodePath = (String)conf.get("sms.code.path");
        this._validPath = (String)conf.get("sms.valid.path");
        this._voiceCodePath = (String)conf.get("sms.voice.code.path");
        this._shortMsgPath = (String)conf.get("sms.message.path");
        this._tempMsgPath = (String)conf.get("sms.template.path");
        this._signPath = (String)conf.get("sms.sign.path");
        this._signDefaultPath = (String)conf.get("sms.sign.default.path");
        this._schedulePath = (String)conf.get("sms.schedule.path");
        this._accountPath = (String)conf.get("sms.account.path");
        this._authCode = authCode = ServiceHelper.getBasicAuthorization((String)appkey, (String)masterSecret);
        this._httpClient = new NativeHttpClient(authCode, proxy, conf.getClientConfig());
    }

    public SendSMSResult sendSMSCode(SMSPayload payload) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"SMS payload should not be null");
        ResponseWrapper response = this._httpClient.sendPost(this._baseUrl + this._smsCodePath, payload.toString());
        return (SendSMSResult)SendSMSResult.fromResponse((ResponseWrapper)response, SendSMSResult.class);
    }

    public ValidSMSResult sendValidSMSCode(String msgId, String code) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != msgId ? 1 : 0) != 0, (Object)"Message id should not be null");
        Pattern codePattern = Pattern.compile("^[0-9]{6}");
        Preconditions.checkArgument((boolean)codePattern.matcher(code).matches(), (Object)"The verification code shoude be consist of six number");
        JsonObject json = new JsonObject();
        json.addProperty(SMS_CODE, code);
        ResponseWrapper response = this._httpClient.sendPost(this._baseUrl + this._smsCodePath + "/" + msgId + this._validPath, json.toString());
        return (ValidSMSResult)ValidSMSResult.fromResponse((ResponseWrapper)response, ValidSMSResult.class);
    }

    public SendSMSResult sendVoiceSMSCode(SMSPayload payload) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"SMS payload should not be null");
        ResponseWrapper response = this._httpClient.sendPost(this._baseUrl + this._voiceCodePath, payload.toString());
        return (SendSMSResult)SendSMSResult.fromResponse((ResponseWrapper)response, SendSMSResult.class);
    }

    public SendSMSResult sendTemplateSMS(SMSPayload payload) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"SMS payload should not be null");
        ResponseWrapper response = this._httpClient.sendPost(this._baseUrl + this._shortMsgPath, payload.toString());
        return (SendSMSResult)SendSMSResult.fromResponse((ResponseWrapper)response, SendSMSResult.class);
    }

    public BatchSMSResult sendBatchTemplateSMS(BatchSMSPayload payload) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"BatchSMSPayload should not be null");
        ResponseWrapper responseWrapper = this._httpClient.sendPost(this._baseUrl + this._shortMsgPath + "/batch", payload.toString());
        return (BatchSMSResult)BatchSMSResult.fromResponse((ResponseWrapper)responseWrapper, BatchSMSResult.class);
    }

    public void setHttpClient(IHttpClient client) {
        this._httpClient = client;
    }

    public void close() {
        if (this._httpClient != null && this._httpClient instanceof NettyHttpClient) {
            ((NettyHttpClient)this._httpClient).close();
        }
    }

    public ScheduleResult sendScheduleSMS(ScheduleSMSPayload payload) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"Schedule SMS payload should not be null");
        Preconditions.checkArgument((null != payload.getMobile() ? 1 : 0) != 0, (Object)"Mobile should not be null");
        Preconditions.checkArgument((boolean)StringUtils.isMobileNumber((String)payload.getMobile()), (Object)"Invalid mobile number");
        ResponseWrapper responseWrapper = this._httpClient.sendPost(this._baseUrl + this._schedulePath, payload.toString());
        return (ScheduleResult)ScheduleResult.fromResponse((ResponseWrapper)responseWrapper, ScheduleResult.class);
    }

    public ScheduleResult updateScheduleSMS(ScheduleSMSPayload payload, String scheduleId) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"Schedule SMS payload should not be null");
        Preconditions.checkArgument((null != scheduleId ? 1 : 0) != 0, (Object)"Schedule id should not be null");
        Preconditions.checkArgument((null != payload.getMobile() ? 1 : 0) != 0, (Object)"Mobile should not be null");
        Preconditions.checkArgument((boolean)StringUtils.isMobileNumber((String)payload.getMobile()), (Object)"Invalid mobile number");
        ResponseWrapper responseWrapper = this._httpClient.sendPut(this._baseUrl + this._schedulePath + "/" + scheduleId, payload.toString());
        return (ScheduleResult)ScheduleResult.fromResponse((ResponseWrapper)responseWrapper, ScheduleResult.class);
    }

    public BatchSMSResult sendBatchScheduleSMS(ScheduleSMSPayload payload) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"Schedule SMS payload should not be null");
        Preconditions.checkArgument((null != payload.getRecipients() ? 1 : 0) != 0, (Object)"Recipients should not be null");
        ResponseWrapper responseWrapper = this._httpClient.sendPost(this._baseUrl + this._schedulePath + "/batch", payload.toString());
        return (BatchSMSResult)BatchSMSResult.fromResponse((ResponseWrapper)responseWrapper, BatchSMSResult.class);
    }

    public BatchSMSResult updateBatchScheduleSMS(ScheduleSMSPayload payload, String scheduleId) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"Schedule SMS payload should not be null");
        Preconditions.checkArgument((null != payload.getRecipients() ? 1 : 0) != 0, (Object)"Recipients should not be null");
        Preconditions.checkArgument((null != scheduleId ? 1 : 0) != 0, (Object)"Schedule id should not be null");
        ResponseWrapper responseWrapper = this._httpClient.sendPut(this._baseUrl + this._schedulePath + "/batch/" + scheduleId, payload.toString());
        return (BatchSMSResult)BatchSMSResult.fromResponse((ResponseWrapper)responseWrapper, BatchSMSResult.class);
    }

    public ScheduleSMSResult getScheduleSMS(String scheduleId) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != scheduleId ? 1 : 0) != 0, (Object)"Schedule id should not be null");
        ResponseWrapper responseWrapper = this._httpClient.sendGet(this._baseUrl + this._schedulePath + "/" + scheduleId);
        return (ScheduleSMSResult)ScheduleSMSResult.fromResponse((ResponseWrapper)responseWrapper, ScheduleSMSResult.class);
    }

    public ResponseWrapper deleteScheduleSMS(String scheduleId) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != scheduleId ? 1 : 0) != 0, (Object)"Schedule id should not be null");
        return this._httpClient.sendDelete(this._baseUrl + this._schedulePath + "/" + scheduleId);
    }

    public AccountBalanceResult getSMSBalance() throws APIConnectionException, APIRequestException {
        ResponseWrapper responseWrapper = this._httpClient.sendGet(this._baseUrl + this._accountPath + "/dev");
        return (AccountBalanceResult)AccountBalanceResult.fromResponse((ResponseWrapper)responseWrapper, AccountBalanceResult.class);
    }

    public AppBalanceResult getAppSMSBalance() throws APIConnectionException, APIRequestException {
        ResponseWrapper responseWrapper = this._httpClient.sendGet(this._baseUrl + this._accountPath + "/app");
        return (AppBalanceResult)AppBalanceResult.fromResponse((ResponseWrapper)responseWrapper, AppBalanceResult.class);
    }

    public SendTempSMSResult createTemplate(TemplatePayload payload) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"Template payload should not be null");
        ResponseWrapper responseWrapper = this._httpClient.sendPost(this._baseUrl + this._tempMsgPath, payload.toString());
        return (SendTempSMSResult)SendTempSMSResult.fromResponse((ResponseWrapper)responseWrapper, SendTempSMSResult.class);
    }

    public SendTempSMSResult updateTemplate(TemplatePayload payload, int tempId) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"Template payload should not be null");
        Preconditions.checkArgument((tempId > 0 ? 1 : 0) != 0, (Object)"temp id is invalid");
        ResponseWrapper responseWrapper = this._httpClient.sendPut(this._baseUrl + this._tempMsgPath + "/" + tempId, payload.toString());
        return (SendTempSMSResult)SendTempSMSResult.fromResponse((ResponseWrapper)responseWrapper, SendTempSMSResult.class);
    }

    public TempSMSResult checkTemplate(int tempId) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((tempId > 0 ? 1 : 0) != 0, (Object)"temp id is invalid");
        ResponseWrapper responseWrapper = this._httpClient.sendGet(this._baseUrl + this._tempMsgPath + "/" + tempId);
        return (TempSMSResult)TempSMSResult.fromResponse((ResponseWrapper)responseWrapper, TempSMSResult.class);
    }

    public ResponseWrapper deleteTemplate(int tempId) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((tempId > 0 ? 1 : 0) != 0, (Object)"temp id is invalid");
        return this._httpClient.sendDelete(this._baseUrl + this._tempMsgPath + "/" + tempId);
    }

    public SignResult createSign(SignPayload payload) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"sign payload should not be null");
        Preconditions.checkArgument((payload.getType() > 0 && payload.getType() <= 7 ? 1 : 0) != 0, (Object)"type should be between 1 and 7");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(SignPayload.getSIGN(), payload.getSign());
        if (!StringUtils.isEmpty((String)payload.getRemark())) {
            Preconditions.checkArgument((payload.getRemark().length() <= 100 ? 1 : 0) != 0, (Object)"remark too long");
            params.put(SignPayload.getREMARK(), payload.getRemark());
        }
        params.put(SignPayload.getTYPE(), payload.getType());
        HashMap<String, byte[]> fileParams = new HashMap<String, byte[]>();
        File[] images = payload.getImages();
        if (images != null && images.length > 0) {
            for (File file : payload.getImages()) {
                fileParams.put(file.getName(), SMSClient.getBytes(file));
            }
        }
        String url = this._baseUrl + this._signPath;
        try {
            ResponseWrapper wrapper = this.doPostSign(url, params, fileParams, SignPayload.getIMAGES());
            if (wrapper.responseCode != 200) {
                throw new APIRequestException(wrapper);
            }
            return (SignResult)SignResult.fromResponse((ResponseWrapper)wrapper, SignResult.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("fail to creat sign");
        }
    }

    public SignResult updateSign(SignPayload payload, int signId) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"sign payload should not be null");
        Preconditions.checkArgument((payload.getType() > 0 && payload.getType() <= 7 ? 1 : 0) != 0, (Object)"type should be between 1 and 7");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(SignPayload.getSIGN(), payload.getSign());
        if (!StringUtils.isEmpty((String)payload.getRemark())) {
            Preconditions.checkArgument((payload.getRemark().length() <= 100 ? 1 : 0) != 0, (Object)"remark too long");
            params.put(SignPayload.getREMARK(), payload.getRemark());
        }
        params.put(SignPayload.getTYPE(), payload.getType());
        HashMap<String, byte[]> fileParams = new HashMap<String, byte[]>();
        File[] images = payload.getImages();
        if (images != null && images.length > 0) {
            for (File file : payload.getImages()) {
                fileParams.put(file.getName(), SMSClient.getBytes(file));
            }
        }
        String url = this._baseUrl + this._signPath + "/" + signId;
        try {
            ResponseWrapper wrapper = this.doPostSign(url, params, fileParams, SignPayload.getIMAGES());
            if (wrapper.responseCode != 200) {
                throw new APIRequestException(wrapper);
            }
            return (SignResult)SignResult.fromResponse((ResponseWrapper)wrapper, SignResult.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("fail to update sign");
        }
    }

    public ResponseWrapper deleteSign(int signId) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((signId > 0 ? 1 : 0) != 0, (Object)"sign id is invalid");
        return this._httpClient.sendDelete(this._baseUrl + this._signPath + "/" + signId);
    }

    public SignInfoResult checkSign(int signId) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((signId > 0 ? 1 : 0) != 0, (Object)"sign id is invalid");
        ResponseWrapper responseWrapper = this._httpClient.sendGet(this._baseUrl + this._signPath + "/" + signId);
        return (SignInfoResult)SignInfoResult.fromResponse((ResponseWrapper)responseWrapper, SignInfoResult.class);
    }

    public ResponseWrapper doPostSign(String strUrl, Map<String, Object> params, Map<String, byte[]> fileParams, String fileName) throws IOException {
        String ret;
        InputStream in;
        ResponseWrapper wrapper = new ResponseWrapper();
        String TWO_HYPHENS = "--";
        String LINE_END = "\r\n";
        URL url = new URL(strUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setRequestProperty("Charset", "utf-8");
        connection.setRequestProperty("Authorization", this._authCode);
        connection.setRequestProperty("Content-Type", "multipart/form-data ; boundary=========7d4a6d158c9");
        connection.connect();
        DataOutputStream out = new DataOutputStream(connection.getOutputStream());
        StringBuffer strBufparam = new StringBuffer();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            String value = String.valueOf(entry.getValue());
            strBufparam.append(TWO_HYPHENS);
            strBufparam.append("========7d4a6d158c9");
            strBufparam.append(LINE_END);
            strBufparam.append("Content-Disposition: form-data; name=\"" + key + "\"");
            strBufparam.append(LINE_END);
            strBufparam.append(LINE_END);
            strBufparam.append(value);
            strBufparam.append(LINE_END);
        }
        out.write(strBufparam.toString().getBytes("utf-8"));
        if (fileParams != null && fileParams.size() > 0) {
            for (Map.Entry<String, byte[]> fileEntry : fileParams.entrySet()) {
                StringBuffer strBufFile = new StringBuffer();
                strBufFile.append(TWO_HYPHENS);
                strBufFile.append("========7d4a6d158c9");
                strBufFile.append(LINE_END);
                strBufFile.append("Content-Disposition: form-data; name=\"" + fileName + "\"; filename=\"" + fileEntry.getKey() + "\"");
                strBufFile.append(LINE_END);
                strBufFile.append("Content-Type:application/octet-stream");
                strBufFile.append(LINE_END);
                strBufFile.append(LINE_END);
                out.write(strBufFile.toString().getBytes("utf-8"));
                out.write(fileEntry.getValue());
                out.write(LINE_END.getBytes());
            }
        }
        byte[] endData = (TWO_HYPHENS + "========7d4a6d158c9" + TWO_HYPHENS + LINE_END).getBytes();
        out.write(endData);
        out.flush();
        out.close();
        int code = connection.getResponseCode();
        try {
            in = code == 200 ? connection.getInputStream() : connection.getErrorStream();
        }
        catch (SSLException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("fail to get inputStream");
        }
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        byte[] buff = new byte[1024];
        if (in != null) {
            int len;
            while ((len = in.read(buff)) != -1) {
                baout.write(buff, 0, len);
            }
            in.close();
        }
        byte[] bytes = baout.toByteArray();
        String responseContentStr = ret = new String(bytes, "utf-8");
        wrapper.responseCode = code;
        wrapper.responseContent = responseContentStr;
        return wrapper;
    }

    public static byte[] getBytes(File f) {
        try {
            int n;
            FileInputStream in = new FileInputStream(f);
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            byte[] b = new byte[1024];
            while ((n = ((InputStream)in).read(b)) != -1) {
                out.write(b, 0, n);
            }
            ((InputStream)in).close();
            out.close();
            return out.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("File is invalid, please check again");
        }
    }
}

