/*
 * Decompiled with CFR 0.152.
 */
package cn.jsms.api.common.model;

import cn.jiguang.common.utils.Preconditions;
import cn.jiguang.common.utils.StringUtils;
import cn.jsms.api.common.model.IModel;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class SMSPayload
implements IModel {
    private static String MOBILE = "mobile";
    private static String TEMP_ID = "temp_id";
    private static String TTL = "ttl";
    private static String TEMP_PARA = "temp_para";
    private String mobile;
    private int temp_id;
    private int ttl;
    private final Map<String, String> temp_para;
    private static Gson gson = new Gson();
    private static final Pattern MOBILE_PATTERN = Pattern.compile("^(((13[0-9])|(14[57])|(15[012356789])|(17[6-8])|(18[0-9]))\\d{8})|((1700)|(1705)|(1709))\\d{7}$");

    private SMSPayload(String mobileNumber, int tempId, int ttl, Map<String, String> temp_para) {
        this.mobile = mobileNumber;
        this.temp_id = tempId;
        this.ttl = ttl;
        this.temp_para = temp_para;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static boolean checkMobile(String mobile) {
        return MOBILE_PATTERN.matcher(mobile).matches();
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = new JsonObject();
        if (null != this.mobile) {
            json.addProperty(MOBILE, this.mobile);
        }
        if (this.temp_id > 0) {
            json.addProperty(TEMP_ID, (Number)this.temp_id);
        }
        if (this.ttl > 0) {
            json.addProperty(TTL, (Number)this.ttl);
        }
        JsonObject tempJson = null;
        if (null != this.temp_para) {
            tempJson = new JsonObject();
            for (String key : this.temp_para.keySet()) {
                tempJson.add(key, (JsonElement)new JsonPrimitive(this.temp_para.get(key)));
            }
        }
        if (null != tempJson) {
            json.add(TEMP_PARA, (JsonElement)tempJson);
        }
        return json;
    }

    public String toString() {
        return gson.toJson(this.toJSON());
    }

    public static class Builder {
        private String mobile;
        private int temp_id;
        private int ttl;
        private Map<String, String> tempParaBuilder;

        public Builder setMobildNumber(String mobileNumber) {
            this.mobile = mobileNumber.trim();
            return this;
        }

        public Builder setTempId(int tempId) {
            this.temp_id = tempId;
            return this;
        }

        public Builder setTTL(int ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder setTempPara(Map<String, String> temp_para) {
            Preconditions.checkArgument((null != temp_para ? 1 : 0) != 0, (Object)"temp_para should not be null.");
            if (null == this.tempParaBuilder) {
                this.tempParaBuilder = new HashMap<String, String>();
            }
            for (String key : temp_para.keySet()) {
                this.tempParaBuilder.put(key, temp_para.get(key));
            }
            return this;
        }

        public Builder addTempPara(String key, String value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.tempParaBuilder) {
                this.tempParaBuilder = new HashMap<String, String>();
            }
            this.tempParaBuilder.put(key, value);
            return this;
        }

        public SMSPayload build() {
            Preconditions.checkArgument((null != this.mobile ? 1 : 0) != 0, (Object)"mobile number should not be null");
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)this.mobile), (Object)"mobile number should not be empty");
            byte[] mobileByte = this.mobile.getBytes();
            if (mobileByte.length != 11) {
                throw new IllegalArgumentException("The length of mobile equals 11. Input is " + this.mobile);
            }
            Preconditions.checkArgument((boolean)SMSPayload.checkMobile(this.mobile), (Object)"invalid mobile number, please check again");
            Preconditions.checkArgument((this.ttl >= 0 ? 1 : 0) != 0, (Object)"ttl should not less 0");
            Preconditions.checkArgument((this.temp_id >= 0 ? 1 : 0) != 0, (Object)"temp id should not less 0");
            return new SMSPayload(this.mobile, this.temp_id, this.ttl, this.tempParaBuilder);
        }
    }
}

