/*
 * Decompiled with CFR 0.152.
 */
package cn.jsms.api.common;

import cn.jiguang.common.ServiceHelper;
import cn.jiguang.common.connection.HttpProxy;
import cn.jiguang.common.connection.NativeHttpClient;
import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jiguang.common.resp.ResponseWrapper;
import cn.jiguang.common.utils.Preconditions;
import cn.jsms.api.SendSMSResult;
import cn.jsms.api.ValidSMSResult;
import cn.jsms.api.common.JSMSConfig;
import cn.jsms.api.common.model.SMSPayload;
import com.google.gson.JsonObject;
import java.util.regex.Pattern;

public class SMSClient {
    private static String SMS_CODE = "code";
    private String _baseUrl;
    private String _smsCodePath;
    private String _validPath;
    private String _voiceCodePath;
    private String _tempMsgPath;
    private NativeHttpClient _httpClient;

    public SMSClient(String masterSecret, String appkey) {
        this(masterSecret, appkey, null, JSMSConfig.getInstance());
    }

    public SMSClient(String masterSecret, String appkey, HttpProxy proxy, JSMSConfig conf) {
        ServiceHelper.checkBasic((String)appkey, (String)masterSecret);
        this._baseUrl = (String)conf.get("sms.api.host.name");
        this._smsCodePath = (String)conf.get("sms.code.path");
        this._validPath = (String)conf.get("sms.valid.path");
        this._voiceCodePath = (String)conf.get("sms.voice.code.path");
        this._tempMsgPath = (String)conf.get("sms.temp.message.path");
        String authCode = ServiceHelper.getBasicAuthorization((String)appkey, (String)masterSecret);
        this._httpClient = new NativeHttpClient(authCode, proxy, conf.getClientConfig());
    }

    public SendSMSResult sendSMSCode(SMSPayload payload) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"SMS payload should not be null");
        ResponseWrapper response = this._httpClient.sendPost(this._baseUrl + this._smsCodePath, payload.toString());
        return (SendSMSResult)SendSMSResult.fromResponse((ResponseWrapper)response, SendSMSResult.class);
    }

    public ValidSMSResult sendValidSMSCode(String msgId, String code) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != msgId ? 1 : 0) != 0, (Object)"Message id should not be null");
        Pattern codePattern = Pattern.compile("^[0-9]{6}");
        Preconditions.checkArgument((boolean)codePattern.matcher(code).matches(), (Object)"The verification code shoude be consist of six number");
        JsonObject json = new JsonObject();
        json.addProperty(SMS_CODE, code);
        ResponseWrapper response = this._httpClient.sendPost(this._baseUrl + this._smsCodePath + "/" + msgId + this._validPath, json.toString());
        return (ValidSMSResult)ValidSMSResult.fromResponse((ResponseWrapper)response, ValidSMSResult.class);
    }

    public SendSMSResult sendVoiceSMSCode(SMSPayload payload) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"SMS payload should not be null");
        ResponseWrapper response = this._httpClient.sendPost(this._baseUrl + this._voiceCodePath, payload.toString());
        return (SendSMSResult)SendSMSResult.fromResponse((ResponseWrapper)response, SendSMSResult.class);
    }

    public SendSMSResult sendTemplateSMS(SMSPayload payload) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != payload ? 1 : 0) != 0, (Object)"SMS payload should not be null");
        ResponseWrapper response = this._httpClient.sendPost(this._baseUrl + this._tempMsgPath, payload.toString());
        return (SendSMSResult)SendSMSResult.fromResponse((ResponseWrapper)response, SendSMSResult.class);
    }
}

