/*
 * Decompiled with CFR 0.152.
 */
package cn.jsms.api.common.model;

import cn.jiguang.commom.utils.Preconditions;
import cn.jiguang.commom.utils.StringUtils;
import cn.jsms.api.common.model.IModel;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.regex.Pattern;

public class SMSPayload
implements IModel {
    private static String MOBILE = "mobile";
    private static String TEMP_ID = "temp_id";
    private String mobile;
    private int temp_id;
    private static Gson gson = new Gson();
    private static final Pattern MOBILE_PATTERN = Pattern.compile("^(((13[0-9])|(14[57])|(15[012356789])|(17[6-8])|(18[0-9]))\\d{8})|((1700)|(1705)|(1709))\\d{7}$");

    public SMSPayload(String mobileNumber, int tempId) {
        this.mobile = mobileNumber;
        this.temp_id = tempId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static boolean checkMobile(String mobile) {
        return MOBILE_PATTERN.matcher(mobile).matches();
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = new JsonObject();
        if (null != this.mobile) {
            json.addProperty(MOBILE, this.mobile);
        }
        if (-1 != this.temp_id) {
            json.addProperty(TEMP_ID, (Number)this.temp_id);
        }
        return json;
    }

    public String toString() {
        return gson.toJson(this.toJSON());
    }

    public static class Builder {
        private String mobile;
        private int temp_id;

        public Builder setMobildNumber(String mobileNumber) {
            this.mobile = mobileNumber.trim();
            return this;
        }

        public Builder setTempId(int tempId) {
            this.temp_id = tempId;
            return this;
        }

        public SMSPayload build() {
            Preconditions.checkArgument((null != this.mobile ? 1 : 0) != 0, (Object)"mobile number should not be null");
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)this.mobile), (Object)"mobile number should not be empty");
            byte[] mobileByte = this.mobile.getBytes();
            if (mobileByte.length != 11) {
                throw new IllegalArgumentException("The length of mobile equals 11. Input is " + this.mobile);
            }
            Preconditions.checkArgument((boolean)SMSPayload.checkMobile(this.mobile), (Object)"invalid mobile number, please check again");
            Preconditions.checkArgument((this.temp_id > 0 ? 1 : 0) != 0, (Object)"temp id should not less 0");
            return new SMSPayload(this.mobile, this.temp_id);
        }
    }
}

