/*
 * Decompiled with CFR 0.152.
 */
package cn.joylau.code;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

public class ZipUtils {
    private static final String CHINESE_CHARSET = "GBK";
    private static final int CACHE_SIZE = 1024;

    public static void zip(String sourceFolder, String zipFilePath) throws Exception {
        FileOutputStream out = new FileOutputStream(zipFilePath);
        BufferedOutputStream bos = new BufferedOutputStream(out);
        ZipOutputStream zos = new ZipOutputStream((OutputStream)bos);
        zos.setEncoding(CHINESE_CHARSET);
        File file = new File(sourceFolder);
        String basePath = null;
        basePath = file.isDirectory() ? file.getPath() : file.getParent();
        ZipUtils.zipFile(file, basePath, zos);
        zos.closeEntry();
        zos.close();
        bos.close();
        ((OutputStream)out).close();
    }

    private static void zipFile(File parentFile, String basePath, ZipOutputStream zos) throws Exception {
        File[] files = new File[]{};
        files = parentFile.isDirectory() ? parentFile.listFiles() : new File[]{parentFile};
        byte[] cache = new byte[1024];
        for (File file : files) {
            String pathName;
            if (file.isDirectory()) {
                pathName = file.getPath().substring(basePath.length() + 1) + "/";
                zos.putNextEntry(new ZipEntry(pathName));
                ZipUtils.zipFile(file, basePath, zos);
                continue;
            }
            pathName = file.getPath().substring(basePath.length() + 1);
            FileInputStream is = new FileInputStream(file);
            BufferedInputStream bis = new BufferedInputStream(is);
            zos.putNextEntry(new ZipEntry(pathName));
            int nRead = 0;
            while ((nRead = bis.read(cache, 0, 1024)) != -1) {
                zos.write(cache, 0, nRead);
            }
            bis.close();
            ((InputStream)is).close();
        }
    }

    public static void unZip(String zipFilePath, String destDir) throws Exception {
        ZipFile zipFile = new ZipFile(zipFilePath, CHINESE_CHARSET);
        Enumeration emu = zipFile.getEntries();
        byte[] cache = new byte[1024];
        while (emu.hasMoreElements()) {
            ZipEntry entry = (ZipEntry)emu.nextElement();
            if (entry.isDirectory()) {
                new File(destDir + entry.getName()).mkdirs();
                continue;
            }
            BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(entry));
            File file = new File(destDir + entry.getName());
            File parentFile = file.getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(file);
            BufferedOutputStream bos = new BufferedOutputStream(fos, 1024);
            int nRead = 0;
            while ((nRead = bis.read(cache, 0, 1024)) != -1) {
                fos.write(cache, 0, nRead);
            }
            bos.flush();
            bos.close();
            fos.close();
            bis.close();
        }
        zipFile.close();
    }
}

