/*
 * Decompiled with CFR 0.152.
 */
package cn.joylau.code;

import cn.joylau.code.ZipUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import org.apache.maven.plugin.AbstractMojo;
import org.codehaus.plexus.util.FileUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class WindowsServiceMojo
extends AbstractMojo {
    private File targetDir;
    private File baseDir;
    private File sourceDir;
    private File testSourceDir;
    private String groupId;
    private String artifactId;
    private String version;
    private String description;
    private String[] arguments;
    private static final String EXE_FILE_URL = "http://image.joylau.cn/plugins/joylau-springboot-daemon-windows/service.exe";
    private static final String XML_FILE_URL = "http://image.joylau.cn/plugins/joylau-springboot-daemon-windows/service.xml";
    private static final String CONFIG_FILE_URL = "http://image.joylau.cn/plugins/joylau-springboot-daemon-windows/service.exe.config";
    private static final String README_FILE_URL = "http://image.joylau.cn/plugins/joylau-springboot-daemon-windows/reamdme.txt";

    public void execute() {
        this.getLog().info((CharSequence)"\u5f00\u59cb\u751f\u6210 Windows Service \u5fc5\u8981\u7684\u6587\u4ef6");
        try {
            File distDir = new File(this.targetDir, File.separator + "dist");
            if (distDir.exists()) {
                try {
                    FileUtils.deleteDirectory((File)distDir);
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)"\u5220\u9664\u76ee\u5f55\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u5728\u4f7f\u7528");
                    e.printStackTrace();
                }
            }
            FileUtils.mkdir((String)distDir.getPath());
            File logDir = new File(distDir, File.separator + "logs");
            FileUtils.mkdir((String)logDir.getPath());
            FileUtils.copyURLToFile((URL)new URL(README_FILE_URL), (File)new File(distDir, File.separator + "\u4f7f\u7528\u8bf4\u660e.txt"));
            FileUtils.copyURLToFile((URL)new URL(XML_FILE_URL), (File)new File(distDir, File.separator + this.getJarPrefixName() + ".xml"));
            FileUtils.copyURLToFile((URL)new URL(EXE_FILE_URL), (File)new File(distDir, File.separator + this.getJarPrefixName() + ".exe"));
            FileUtils.copyURLToFile((URL)new URL(CONFIG_FILE_URL), (File)new File(distDir, File.separator + this.getJarPrefixName() + ".exe.config"));
            FileUtils.copyFile((File)new File(this.targetDir.getPath() + File.separator + this.getJarName()), (File)new File(distDir, File.separator + this.getJarName()));
            this.convert(new File(distDir.getPath() + File.separator + this.getJarPrefixName() + ".xml"));
            this.createBat(distDir, "intsall.bat", "install");
            this.createBat(distDir, "unintall.bat", "uninstall");
            this.createBat(distDir, "start.bat", "start");
            this.createBat(distDir, "stop.bat", "stop");
            this.createBat(distDir, "restart.bat", "restart");
            this.getLog().info((CharSequence)"\u6b63\u5728\u5236\u4f5c\u538b\u7f29\u5305....");
            String zipDir = this.targetDir.getPath() + File.separator + this.getJarPrefixName() + ".zip";
            ZipUtils.zip(distDir.getPath(), zipDir);
            this.getLog().info((CharSequence)"\u6b63\u5728\u6e05\u9664\u4e34\u65f6\u6587\u4ef6....");
            FileUtils.deleteDirectory((File)distDir);
            this.getLog().info((CharSequence)("\u5236\u4f5c\u5b8c\u6210\uff0c\u6587\u4ef6:" + zipDir));
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"\u5236\u4f5cWindows Service \u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    private void convert(File xmlFile) {
        SAXReader reader = new SAXReader();
        try {
            Document document = reader.read(xmlFile);
            Element root = document.getRootElement();
            root.element("id").setText(this.artifactId);
            root.element("name").setText(this.getJarPrefixName());
            root.element("description").setText(null == this.description ? "\u6682\u65e0\u63cf\u8ff0" : this.description);
            String javaArguments = "";
            if (this.arguments != null) {
                for (String argument : this.arguments) {
                    javaArguments = " " + argument;
                }
            }
            root.element("arguments").setText("-jar " + this.getJarName() + javaArguments);
            this.saveXML(document, xmlFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveXML(Document document, File xmlFile) {
        try {
            XMLWriter writer = new XMLWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(xmlFile), "UTF-8"));
            writer.write(document);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBat(File outDri, String fileName, String text) {
        if (!outDri.exists()) {
            FileUtils.mkdir((String)outDri.getPath());
        }
        File file = new File(outDri, fileName);
        FileWriter w = null;
        try {
            w = new FileWriter(file);
            w.write("@echo off\n%~dp0" + this.getJarPrefixName() + ".exe " + text + "\n" + "echo The " + this.getJarPrefixName() + " service current state:\n" + "%~dp0" + this.getJarPrefixName() + ".exe status\n" + "pause");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (w != null) {
                try {
                    w.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String getJarPrefixName() {
        return this.artifactId + "-" + this.version;
    }

    private String getJarName() {
        return this.getJarPrefixName() + ".jar";
    }
}

