/*
 * Decompiled with CFR 0.152.
 */
package cn.jmonitor.monitor4j.websupport.collector;

import cn.jmonitor.monitor4j.client.protocal.message.GetAttribute;
import cn.jmonitor.monitor4j.jmx.JMXUtils;
import cn.jmonitor.monitor4j.utils.JsonUtils;
import cn.jmonitor.monitor4j.websupport.JmonitorDataComparator;
import cn.jmonitor.monitor4j.websupport.collector.BaseCollector;
import cn.jmonitor.monitor4j.websupport.items.WebSingleUrlForWeb;
import cn.jmonitor.monitor4j.websupport.items.WebUrl;
import cn.jmonitor.monitor4j.websupport.items.WebUrlStat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;

public class WebUrlCollector
extends BaseCollector {
    private static ArrayBlockingQueue<WebUrl> urlQueue = new ArrayBlockingQueue(1440);

    public static void doCollect() {
        GetAttribute urlAttribute = new GetAttribute();
        urlAttribute.setAttributeNames(Arrays.asList("JmonitorDataList"));
        urlAttribute.setObjectName("cn.jmonitor.monitor4j:type=WebUrl");
        urlAttribute.setOptions(Arrays.asList("reset=true"));
        String urlMapStr = JsonUtils.toJsonString(JMXUtils.getAttributeFormatted(urlAttribute));
        List<WebUrlStat> webUrlStats = JsonUtils.parseArray(urlMapStr, WebUrlStat.class);
        WebUrl webUrl = new WebUrl();
        for (WebUrlStat webUrlStat : webUrlStats) {
            webUrl.getUriMap().put(webUrlStat.getUrl(), webUrlStat);
        }
        webUrl.setTimeStamp(new Date());
        WebUrlCollector.checkQueueSize(urlQueue);
        urlQueue.offer(webUrl);
    }

    public static String getWebUrlForHtml(Integer timeInterval) {
        if (null == timeInterval) {
            throw new IllegalArgumentException("timeInterval can not be null!");
        }
        HashMap<String, WebUrlStat> map = new HashMap<String, WebUrlStat>();
        int count = 0;
        String keyTitle = "URL";
        for (WebUrl webUrl : urlQueue) {
            WebUrlCollector.mergeWebUrlMap(map, webUrl.getUriMap());
            if (++count != timeInterval) continue;
            break;
        }
        String result = "<table style='width: 94%;'>";
        result = result + "<tr><td class='title'>" + keyTitle + "(count:" + map.size() + ")</td><td class='titleMin'>\u8bbf\u95ee\u6b21\u6570</td><td class='titleMin'>\u6700\u5927\u5e76\u53d1</td><td class='titleMin'>\u5e73\u5747\u8017\u65f6(ms)</td><td class='titleMin'>\u6700\u5927\u8017\u65f6(ms)</td><td class='titleMin'>\u9519\u8bef\u6570</td></tr>";
        ArrayList webUrlStatList = new ArrayList(map.values());
        Collections.sort(webUrlStatList, new JmonitorDataComparator("count", "DESC"));
        for (WebUrlStat entry : webUrlStatList) {
            long weburlCount = entry.getCount();
            if (weburlCount == 0L) {
                weburlCount = 1L;
            }
            result = result + "<tr>";
            result = result + "<td><a href='javascript:;' onclick='createWebUrlDetailChart(\"" + entry.getUrl() + "\")'><img src='css/images/chart.png' class='middle-img'></a><a href='javascript:;' onclick='showUrlProfile(\"" + entry.getUrl() + "\")'><img src='css/images/more.png' class='middle-img'></a>" + entry.getUrl() + "</td>";
            result = result + "<td>" + entry.getCount() + "</td>";
            result = result + "<td>" + entry.getConcurrentMax() + "</td>";
            result = result + "<td>" + entry.getNanoTotal() / (weburlCount * 1000000L) + "</td>";
            result = result + "<td>" + entry.getNanoMax() / 1000000L + "</td>";
            result = result + "<td>" + entry.getErrorCount() + "</td>";
            result = result + "</tr>";
        }
        result = result + "</table>";
        return result;
    }

    private static void mergeWebUrlMap(Map<String, WebUrlStat> resultMap, Map<String, WebUrlStat> targetMap) {
        if (null == resultMap || null == targetMap) {
            return;
        }
        for (Map.Entry<String, WebUrlStat> entry : targetMap.entrySet()) {
            WebUrlStat webUrlStat = resultMap.get(entry.getKey());
            if (null == webUrlStat) {
                webUrlStat = new WebUrlStat();
                webUrlStat.setUrl(new String(entry.getKey()));
                resultMap.put(webUrlStat.getUrl(), webUrlStat);
            }
            webUrlStat.setCount(webUrlStat.getCount() + entry.getValue().getCount());
            webUrlStat.setErrorCount(webUrlStat.getErrorCount() + entry.getValue().getErrorCount());
            webUrlStat.setNanoTotal(webUrlStat.getNanoTotal() + entry.getValue().getNanoTotal());
            if (entry.getValue().getConcurrentMax() > webUrlStat.getConcurrentMax()) {
                webUrlStat.setConcurrentMax(entry.getValue().getConcurrentMax());
            }
            if (entry.getValue().getNanoMax() <= webUrlStat.getNanoMax()) continue;
            webUrlStat.setNanoMax(entry.getValue().getNanoMax());
        }
    }

    public static List<WebSingleUrlForWeb> getWebSingleUrlForWebList(String url) {
        ArrayList<WebSingleUrlForWeb> result = new ArrayList<WebSingleUrlForWeb>();
        ArrayList<WebUrl> list = new ArrayList<WebUrl>();
        for (WebUrl webUrl : urlQueue) {
            list.add(webUrl);
        }
        for (WebUrl webUrl : list) {
            WebUrlStat stat = webUrl.getUriMap().get(url);
            if (null == stat) continue;
            WebSingleUrlForWeb urlForWeb = new WebSingleUrlForWeb(url, stat, webUrl.getTimeStamp());
            result.add(urlForWeb);
        }
        return result;
    }

    public static String getWebUrlErrorForHtml(String url) {
        HashMap<String, String> map = new HashMap<String, String>();
        int count = 0;
        for (WebUrl webUrl : urlQueue) {
            WebUrlStat webUrlStat = webUrl.getUriMap().get(url);
            if (null == webUrlStat || null == webUrlStat.getLastErrorMsg() || "".equals(webUrlStat.getLastErrorMsg())) continue;
            map.put(DateFormat.format(webUrl.getTimeStamp()), webUrlStat.getLastErrorMsg());
            if (++count != 10) continue;
            break;
        }
        String result = "<table style='width: 100%;'>";
        result = result + "<tr><td class='titleMin'>\u65f6\u95f4</td><td class='titleMin'>\u9519\u8bef\u4fe1\u606f(" + url + ")</td></tr>";
        for (Map.Entry entry : map.entrySet()) {
            result = result + "<tr>";
            result = result + "<td>" + (String)entry.getKey() + "</td>";
            result = result + "<td>" + (String)entry.getValue() + "</td>";
            result = result + "</tr>";
        }
        result = result + "</table>";
        return result;
    }
}

