/*
 * Decompiled with CFR 0.152.
 */
package cn.jmonitor.monitor4j.websupport.collector;

import cn.jmonitor.monitor4j.client.protocal.message.GetAttribute;
import cn.jmonitor.monitor4j.jmx.JMXUtils;
import cn.jmonitor.monitor4j.utils.JsonUtils;
import cn.jmonitor.monitor4j.utils.StringUtils;
import cn.jmonitor.monitor4j.websupport.collector.BaseCollector;
import cn.jmonitor.monitor4j.websupport.items.WebProfile;
import cn.jmonitor.monitor4j.websupport.items.WebProfileInfo;
import cn.jmonitor.monitor4j.websupport.items.WebProfileStat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;

public class WebProfileCollector
extends BaseCollector {
    private static ArrayBlockingQueue<WebProfile> queue = new ArrayBlockingQueue(1440);

    public static void doCollect() {
        GetAttribute getAttribute = new GetAttribute();
        getAttribute.setAttributeNames(Arrays.asList("JmonitorDataList"));
        getAttribute.setObjectName("cn.jmonitor.monitor4j:type=WebUrlProfile");
        getAttribute.setOptions(Arrays.asList("reset=true"));
        String mapStr = JsonUtils.toJsonString(JMXUtils.getAttributeFormatted(getAttribute));
        List<WebProfileStat> webProfileStats = JsonUtils.parseArray(mapStr, WebProfileStat.class);
        WebProfile webProfile = new WebProfile();
        for (WebProfileStat webProfileStat : webProfileStats) {
            webProfile.getMap().put(webProfileStat.buildWebProfileInfo(), webProfileStat);
        }
        webProfile.setTimeStamp(new Date());
        WebProfileCollector.checkQueueSize(queue);
        queue.offer(webProfile);
    }

    public static String getWebProfileForHtml(String url, Integer timeInterval) {
        if (null == timeInterval) {
            throw new IllegalArgumentException("timeInterval can not be null!");
        }
        if (null == url) {
            throw new IllegalArgumentException("url can not be null!");
        }
        HashMap<WebProfileInfo, WebProfileStat> map = new HashMap<WebProfileInfo, WebProfileStat>();
        int count = 0;
        for (WebProfile webProfile : queue) {
            WebProfileCollector.mergeMap(map, webProfile.getMap());
            if (++count != timeInterval) continue;
            break;
        }
        String result = "<table style='width: 100%;'>";
        result = result + "<tr><td class='title'>\u7c7b\u578b(count:" + map.size() + ")</td><td class='title'>\u540d\u79f0</td><td class='titleMin'>\u8bbf\u95ee\u6b21\u6570</td><td class='titleMin'>\u6700\u5927\u5e76\u53d1</td><td class='titleMin'>\u5e73\u5747\u8017\u65f6(ms)</td><td class='titleMin'>\u6700\u5927\u8017\u65f6(ms)</td><td class='titleMin'>\u9519\u8bef\u6570</td></tr>";
        for (WebProfileStat entry : map.values()) {
            if (!url.equals(entry.getUrl())) continue;
            result = result + "<tr>";
            result = result + "<td>" + entry.getType() + "</td>";
            result = result + "<td>" + entry.getName() + "</td>";
            result = result + "<td>" + entry.getCount() + "</td>";
            result = result + "<td>" + entry.getConcurrentMax() + "</td>";
            result = result + "<td>" + entry.getNanoTotal() / (entry.getCount() * 1000000L) + "</td>";
            result = result + "<td>" + entry.getNanoMax() / 1000000L + "</td>";
            result = result + "<td>" + entry.getErrorCount() + "</td>";
            result = result + "</tr>";
        }
        result = result + "</table>";
        return result;
    }

    private static void mergeMap(Map<WebProfileInfo, WebProfileStat> resultMap, Map<WebProfileInfo, WebProfileStat> targetMap) {
        if (null == resultMap || null == targetMap) {
            return;
        }
        for (Map.Entry<WebProfileInfo, WebProfileStat> entry : targetMap.entrySet()) {
            WebProfileStat webProfileStat = resultMap.get(entry.getKey());
            if (null == webProfileStat) {
                webProfileStat = new WebProfileStat();
                webProfileStat.setUrl(entry.getKey().getUrl());
                webProfileStat.setType(entry.getKey().getType());
                webProfileStat.setName(entry.getKey().getName());
                resultMap.put(entry.getKey(), webProfileStat);
            }
            webProfileStat.setCount(webProfileStat.getCount() + entry.getValue().getCount());
            webProfileStat.setErrorCount(webProfileStat.getErrorCount() + entry.getValue().getErrorCount());
            webProfileStat.setNanoTotal(webProfileStat.getNanoTotal() + entry.getValue().getNanoTotal());
            if (entry.getValue().getConcurrentMax() > webProfileStat.getConcurrentMax()) {
                webProfileStat.setConcurrentMax(entry.getValue().getConcurrentMax());
            }
            if (entry.getValue().getNanoMax() > webProfileStat.getNanoMax()) {
                webProfileStat.setNanoMax(entry.getValue().getNanoMax());
            }
            if (!StringUtils.isNotBlank(entry.getValue().getLastErrorMsg()) || entry.getValue().getLastErrorTime() == null || webProfileStat.getLastErrorTime() != null && webProfileStat.getLastErrorTime().getTime() >= entry.getValue().getLastErrorTime().getTime()) continue;
            webProfileStat.setLastErrorTime(entry.getValue().getLastErrorTime());
            webProfileStat.setLastErrorMsg(entry.getValue().getLastErrorMsg());
        }
    }
}

