/*
 * Decompiled with CFR 0.152.
 */
package cn.jmonitor.monitor4j.websupport.collector;

import cn.jmonitor.monitor4j.client.protocal.message.GetAttribute;
import cn.jmonitor.monitor4j.jmx.JMXUtils;
import cn.jmonitor.monitor4j.utils.JsonUtils;
import cn.jmonitor.monitor4j.utils.StringUtils;
import cn.jmonitor.monitor4j.websupport.JmonitorDataComparator;
import cn.jmonitor.monitor4j.websupport.collector.BaseCollector;
import cn.jmonitor.monitor4j.websupport.items.WebIP;
import cn.jmonitor.monitor4j.websupport.items.WebIPStat;
import cn.jmonitor.monitor4j.websupport.items.WebSingleIPForWeb;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;

public class WebIPCollector
extends BaseCollector {
    private static ArrayBlockingQueue<WebIP> webIpQueue = new ArrayBlockingQueue(1440);

    public static void doCollect() {
        GetAttribute ipAttribute = new GetAttribute();
        ipAttribute.setAttributeNames(Arrays.asList("JmonitorDataList"));
        ipAttribute.setObjectName("cn.jmonitor.monitor4j:type=WebIP");
        ipAttribute.setOptions(Arrays.asList("reset=true"));
        String ipMapStr = JsonUtils.toJsonString(JMXUtils.getAttributeFormatted(ipAttribute));
        List<WebIPStat> webIPStats = JsonUtils.parseArray(ipMapStr, WebIPStat.class);
        WebIP webIP = new WebIP();
        for (WebIPStat webIPStat : webIPStats) {
            webIP.getIPMap().put(webIPStat.getIp(), webIPStat);
        }
        webIP.setTimeStamp(new Date());
        WebIPCollector.checkQueueSize(webIpQueue);
        webIpQueue.offer(webIP);
    }

    public static String getWebIPForHtml(Integer timeInterval) {
        if (null == timeInterval) {
            throw new IllegalArgumentException("timeInterval can not be null!");
        }
        HashMap<String, WebIPStat> map = new HashMap<String, WebIPStat>();
        int count = 0;
        String keyTitle = "IP";
        for (WebIP ip : webIpQueue) {
            WebIPCollector.mergeWebIPMap(map, ip.getIPMap());
            if (++count != timeInterval) continue;
            break;
        }
        String result = "<table style='width: 94%;'>";
        result = result + "<tr><td class='title'>" + keyTitle + "(count:" + map.size() + ")</td><td class='titleMin'>\u8bbf\u95ee\u6b21\u6570</td><td class='titleMin'>\u6700\u5927\u5e76\u53d1</td><td class='titleMin'>\u5e73\u5747\u8017\u65f6(ms)</td><td class='titleMin'>\u6700\u5927\u8017\u65f6(ms)</td><td class='titleMin'>\u9519\u8bef\u6570</td></tr>";
        ArrayList webIPStatList = new ArrayList(map.values());
        Collections.sort(webIPStatList, new JmonitorDataComparator("count", "DESC"));
        for (WebIPStat entry : webIPStatList) {
            result = result + "<tr>";
            result = result + "<td><a href='#' onclick='createWebIPDetailChart(\"" + entry.getIp() + "\")'><img src='css/images/chart.png' class='middle-img'></a>" + entry.getIp() + "</td>";
            result = result + "<td>" + entry.getCount() + "</td>";
            result = result + "<td>" + entry.getConcurrentMax() + "</td>";
            result = result + "<td>" + entry.getNanoTotal() / (entry.getCount() * 1000000L) + "</td>";
            result = result + "<td>" + entry.getNanoMax() / 1000000L + "</td>";
            result = result + "<td>" + entry.getErrorCount() + "</td>";
            result = result + "</tr>";
        }
        result = result + "</table>";
        return result;
    }

    private static void mergeWebIPMap(Map<String, WebIPStat> resultMap, Map<String, WebIPStat> targetMap) {
        if (null == resultMap || null == targetMap) {
            return;
        }
        for (Map.Entry<String, WebIPStat> entry : targetMap.entrySet()) {
            WebIPStat webIPStat = resultMap.get(entry.getKey());
            if (null == webIPStat) {
                webIPStat = new WebIPStat();
                webIPStat.setIp(new String(entry.getKey()));
                resultMap.put(webIPStat.getIp(), webIPStat);
            }
            webIPStat.setCount(webIPStat.getCount() + entry.getValue().getCount());
            webIPStat.setErrorCount(webIPStat.getErrorCount() + entry.getValue().getErrorCount());
            webIPStat.setNanoTotal(webIPStat.getNanoTotal() + entry.getValue().getNanoTotal());
            if (entry.getValue().getConcurrentMax() > webIPStat.getConcurrentMax()) {
                webIPStat.setConcurrentMax(entry.getValue().getConcurrentMax());
            }
            if (entry.getValue().getNanoMax() <= webIPStat.getNanoMax()) continue;
            webIPStat.setNanoMax(entry.getValue().getNanoMax());
        }
    }

    public static List<WebSingleIPForWeb> getWebSingleIPForWebList(String ip) {
        ArrayList<WebSingleIPForWeb> result = new ArrayList<WebSingleIPForWeb>();
        ArrayList<WebIP> list = new ArrayList<WebIP>();
        for (WebIP webIP : webIpQueue) {
            list.add(webIP);
        }
        for (WebIP webIP : list) {
            WebIPStat stat = webIP.getIPMap().get(ip);
            if (null == stat) continue;
            WebSingleIPForWeb ipForWeb = new WebSingleIPForWeb(ip, stat, webIP.getTimeStamp());
            result.add(ipForWeb);
        }
        return result;
    }

    public static String getWebIPErrorForHtml(String ip) {
        HashMap<String, String> map = new HashMap<String, String>();
        int count = 0;
        for (WebIP webIP : webIpQueue) {
            WebIPStat stat = webIP.getIPMap().get(ip);
            if (null == stat || StringUtils.isBlank(stat.getLastErrorMsg())) continue;
            map.put(DateFormat.format(webIP.getTimeStamp()), stat.getLastErrorMsg());
            if (++count != 10) continue;
            break;
        }
        String result = "<table style='width: 100%;'>";
        result = result + "<tr><td class='titleMin'>\u65f6\u95f4</td><td class='titleMin'>\u9519\u8bef\u4fe1\u606f(" + ip + ")</td></tr>";
        for (Map.Entry entry : map.entrySet()) {
            result = result + "<tr>";
            result = result + "<td>" + (String)entry.getKey() + "</td>";
            result = result + "<td>" + (String)entry.getValue() + "</td>";
            result = result + "</tr>";
        }
        result = result + "</table>";
        return result;
    }
}

