/*
 * Decompiled with CFR 0.152.
 */
package cn.jmonitor.monitor4j.websupport.collector;

import cn.jmonitor.monitor4j.client.protocal.message.GetAttribute;
import cn.jmonitor.monitor4j.jmx.JMXUtils;
import cn.jmonitor.monitor4j.utils.JsonUtils;
import cn.jmonitor.monitor4j.websupport.JmonitorDataComparator;
import cn.jmonitor.monitor4j.websupport.collector.BaseCollector;
import cn.jmonitor.monitor4j.websupport.items.JdbcSql;
import cn.jmonitor.monitor4j.websupport.items.JdbcSqlStat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;

public class SqlCollector
extends BaseCollector {
    private static ArrayBlockingQueue<JdbcSql> sqlQueue = new ArrayBlockingQueue(1440);

    public static void doCollect() {
        GetAttribute sqlAttribute = new GetAttribute();
        sqlAttribute.setAttributeNames(Arrays.asList("SqlList"));
        sqlAttribute.setObjectName("cn.jmonitor.monitor4j:type=DruidSql");
        sqlAttribute.setOptions(Arrays.asList("reset=true"));
        String sqlMapStr = JsonUtils.toJsonString(JMXUtils.getAttributeFormatted(sqlAttribute));
        List<JdbcSqlStat> jdbcSqlStats = JsonUtils.parseArray(sqlMapStr, JdbcSqlStat.class);
        JdbcSql jdbcSql = new JdbcSql();
        for (JdbcSqlStat jdbcSqlStat : jdbcSqlStats) {
            jdbcSql.getMap().put(jdbcSqlStat.getSql(), jdbcSqlStat);
        }
        jdbcSql.setTimeStamp(new Date());
        SqlCollector.checkQueueSize(sqlQueue);
        sqlQueue.offer(jdbcSql);
    }

    public static String getSqlIForHtml(Integer timeInterval) {
        if (null == timeInterval) {
            throw new IllegalArgumentException("timeInterval can not be null!");
        }
        HashMap<String, JdbcSqlStat> map = new HashMap<String, JdbcSqlStat>();
        int count = 0;
        String keyTitle = "Sql";
        for (JdbcSql jdbcSql : sqlQueue) {
            SqlCollector.mergeJdbcSqlMap(map, jdbcSql.getMap());
            if (++count != timeInterval) continue;
            break;
        }
        String result = "<table style='width: 94%;'>";
        result = result + "<tr><td class='title'>" + keyTitle + "(count:" + map.size() + ")</td><td class='titleMin'>\u8bbf\u95ee\u6b21\u6570</td><td class='titleMin'>\u6700\u5927\u5e76\u53d1</td><td class='titleMin'>\u5e73\u5747\u8017\u65f6(ms)</td><td class='titleMin'>\u6700\u5927\u8017\u65f6(ms)</td><td class='titleMin'>\u9519\u8bef\u6570</td><td class='titleMin'>\u5e73\u5747\u6293\u53d6</td><td class='titleMin'>\u6700\u5927\u6293\u53d6</td><td class='titleMin'>\u5e73\u5747\u5f71\u54cd</td><td class='titleMin'>\u6700\u5927\u5f71\u54cd</td></tr>";
        ArrayList jdbcSqlStatList = new ArrayList(map.values());
        Collections.sort(jdbcSqlStatList, new JmonitorDataComparator("count", "DESC"));
        for (JdbcSqlStat entry : jdbcSqlStatList) {
            result = result + "<tr>";
            result = result + "<td><a href='#'></a>" + entry.getSql().replaceAll("\r", " ").replaceAll("\n", " ").replaceAll("\t", " ") + "</td>";
            result = result + "<td>" + entry.getCount() + "</td>";
            result = result + "<td>" + entry.getConcurrentMax() + "</td>";
            result = result + "<td>" + entry.getTotalTime() / entry.getCount() + "</td>";
            result = result + "<td>" + entry.getMaxTime() + "</td>";
            result = result + "<td>" + entry.getErrorCount() + "</td>";
            result = result + "<td>" + entry.getFetchRowCount() / entry.getCount() + "</td>";
            result = result + "<td>" + entry.getFetchRowCountMax() + "</td>";
            result = result + "<td>" + entry.getEffectedRowCount() / entry.getCount() + "</td>";
            result = result + "<td>" + entry.getEffectedRowCountMax() + "</td>";
            result = result + "</tr>";
        }
        result = result + "</table>";
        return result;
    }

    private static void mergeJdbcSqlMap(Map<String, JdbcSqlStat> resultMap, Map<String, JdbcSqlStat> targetMap) {
        if (null == resultMap || null == targetMap) {
            return;
        }
        for (Map.Entry<String, JdbcSqlStat> entry : targetMap.entrySet()) {
            JdbcSqlStat jdbcSqlStat = resultMap.get(entry.getKey());
            if (null == jdbcSqlStat) {
                jdbcSqlStat = new JdbcSqlStat();
                jdbcSqlStat.setSql(new String(entry.getKey()));
                resultMap.put(jdbcSqlStat.getSql(), jdbcSqlStat);
            }
            jdbcSqlStat.setCount(jdbcSqlStat.getCount() + entry.getValue().getCount());
            jdbcSqlStat.setErrorCount(jdbcSqlStat.getErrorCount() + entry.getValue().getErrorCount());
            jdbcSqlStat.setTotalTime(jdbcSqlStat.getTotalTime() + entry.getValue().getTotalTime());
            if (entry.getValue().getConcurrentMax() > jdbcSqlStat.getConcurrentMax()) {
                jdbcSqlStat.setConcurrentMax(entry.getValue().getConcurrentMax());
            }
            if (entry.getValue().getMaxTime() > jdbcSqlStat.getMaxTime()) {
                jdbcSqlStat.setMaxTime(entry.getValue().getMaxTime());
            }
            if (entry.getValue().getEffectedRowCountMax() > jdbcSqlStat.getEffectedRowCountMax()) {
                jdbcSqlStat.setEffectedRowCountMax(entry.getValue().getEffectedRowCountMax());
            }
            if (entry.getValue().getFetchRowCountMax() <= jdbcSqlStat.getFetchRowCountMax()) continue;
            jdbcSqlStat.setFetchRowCountMax(entry.getValue().getFetchRowCountMax());
        }
    }
}

