/*
 * Decompiled with CFR 0.152.
 */
package cn.jmonitor.monitor4j.websupport.collector;

import cn.jmonitor.monitor4j.client.protocal.message.GetAttribute;
import cn.jmonitor.monitor4j.jmx.JMXUtils;
import cn.jmonitor.monitor4j.utils.JsonUtils;
import cn.jmonitor.monitor4j.utils.StringUtils;
import cn.jmonitor.monitor4j.websupport.JmonitorDataComparator;
import cn.jmonitor.monitor4j.websupport.collector.BaseCollector;
import cn.jmonitor.monitor4j.websupport.items.SpringMethod;
import cn.jmonitor.monitor4j.websupport.items.SpringMethodInfo;
import cn.jmonitor.monitor4j.websupport.items.SpringMethodSingleForWeb;
import cn.jmonitor.monitor4j.websupport.items.SpringMethodStat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;

public class SpringMethodCollector
extends BaseCollector {
    private static ArrayBlockingQueue<SpringMethod> springMethodQueue = new ArrayBlockingQueue(1440);

    public static void doCollect() {
        GetAttribute springAttribute = new GetAttribute();
        springAttribute.setAttributeNames(Arrays.asList("JmonitorDataList"));
        springAttribute.setObjectName("cn.jmonitor.monitor4j:type=SpringMethod");
        springAttribute.setOptions(Arrays.asList("reset=true"));
        String springMapStr = JsonUtils.toJsonString(JMXUtils.getAttributeFormatted(springAttribute));
        List<SpringMethodStat> springMethodStats = JsonUtils.parseArray(springMapStr, SpringMethodStat.class);
        SpringMethod springMethod = new SpringMethod();
        for (SpringMethodStat springMethodStat : springMethodStats) {
            springMethod.getMethodMap().put(springMethodStat.buildSpringMethodInfo(), springMethodStat);
        }
        springMethod.setTimeStamp(new Date());
        SpringMethodCollector.checkQueueSize(springMethodQueue);
        springMethodQueue.offer(springMethod);
    }

    public static String getSpringMethodForHtml(Integer timeInterval) {
        if (null == timeInterval) {
            throw new IllegalArgumentException("timeInterval can not be null!");
        }
        HashMap<SpringMethodInfo, SpringMethodStat> map = new HashMap<SpringMethodInfo, SpringMethodStat>();
        int count = 0;
        ArrayBlockingQueue<SpringMethod> queue = springMethodQueue;
        for (SpringMethod springMethod : queue) {
            SpringMethodCollector.mergeSpringMethodMap(map, springMethod.getMethodMap());
            if (++count != timeInterval) continue;
            break;
        }
        String result = "<table style='width: 94%;'>";
        result = result + "<tr><td class='title'>\u7c7b\u540d(count:" + map.size() + ")</td><td class='title'>\u65b9\u6cd5\u540d\u79f0</td><td class='titleMin'>\u8bbf\u95ee\u6b21\u6570</td><td class='titleMin'>\u6700\u5927\u5e76\u53d1</td><td class='titleMin'>\u5e73\u5747\u8017\u65f6(ms)</td><td class='titleMin'>\u6700\u5927\u8017\u65f6(ms)</td><td class='titleMin'>\u9519\u8bef\u6570</td></tr>";
        ArrayList springMethodStatList = new ArrayList(map.values());
        Collections.sort(springMethodStatList, new JmonitorDataComparator("count", "DESC"));
        for (SpringMethodStat entry : springMethodStatList) {
            result = result + "<tr>";
            result = result + "<td><a href='#' onclick='createSpringMethodDetailChart(\"" + entry.getClassName() + "\",\"" + entry.getMethod() + "\")'><img src='css/images/chart.png' class='middle-img'></a>" + entry.getClassName() + "</td>";
            result = result + "<td>" + entry.getMethod() + "</td>";
            result = result + "<td>" + entry.getCount() + "</td>";
            result = result + "<td>" + entry.getConcurrentMax() + "</td>";
            result = result + "<td>" + entry.getNanoTotal() / (entry.getCount() * 1000000L) + "</td>";
            result = result + "<td>" + entry.getNanoMax() / 1000000L + "</td>";
            result = result + "<td>" + entry.getErrorCount() + "</td>";
            result = result + "</tr>";
        }
        result = result + "</table>";
        return result;
    }

    private static void mergeSpringMethodMap(Map<SpringMethodInfo, SpringMethodStat> resultMap, Map<SpringMethodInfo, SpringMethodStat> targetMap) {
        if (null == resultMap || null == targetMap) {
            return;
        }
        for (Map.Entry<SpringMethodInfo, SpringMethodStat> entry : targetMap.entrySet()) {
            SpringMethodStat springMethodStat = resultMap.get(entry.getKey());
            if (null == springMethodStat) {
                springMethodStat = new SpringMethodStat();
                springMethodStat.setClassName(entry.getKey().getClassName());
                springMethodStat.setMethod(entry.getKey().getMethod());
                resultMap.put(entry.getKey(), springMethodStat);
            }
            springMethodStat.setCount(springMethodStat.getCount() + entry.getValue().getCount());
            springMethodStat.setErrorCount(springMethodStat.getErrorCount() + entry.getValue().getErrorCount());
            springMethodStat.setNanoTotal(springMethodStat.getNanoTotal() + entry.getValue().getNanoTotal());
            if (entry.getValue().getConcurrentMax() > springMethodStat.getConcurrentMax()) {
                springMethodStat.setConcurrentMax(entry.getValue().getConcurrentMax());
            }
            if (entry.getValue().getNanoMax() <= springMethodStat.getNanoMax()) continue;
            springMethodStat.setNanoMax(entry.getValue().getNanoMax());
        }
    }

    public static List<SpringMethodSingleForWeb> getSingleSpringMethodForWebList(String className, String method) {
        ArrayList<SpringMethodSingleForWeb> result = new ArrayList<SpringMethodSingleForWeb>();
        SpringMethodInfo springMethodInfo = new SpringMethodInfo(className, method);
        for (SpringMethod springMethod : springMethodQueue) {
            SpringMethodStat stat = springMethod.getMethodMap().get(springMethodInfo);
            if (null == stat) continue;
            SpringMethodSingleForWeb methodSingleForWeb = new SpringMethodSingleForWeb(springMethodInfo, stat, springMethod.getTimeStamp());
            result.add(methodSingleForWeb);
        }
        return result;
    }

    public static String getSpringMethodErrorForHtml(String className, String method) {
        HashMap<String, String> map = new HashMap<String, String>();
        SpringMethodInfo methodInfo = new SpringMethodInfo(className, method);
        int count = 0;
        for (SpringMethod springMethod : springMethodQueue) {
            SpringMethodStat springMethodStat = springMethod.getMethodMap().get(methodInfo);
            if (null == springMethodStat || StringUtils.isBlank(springMethodStat.getLastErrorMsg())) continue;
            map.put(DateFormat.format(springMethod.getTimeStamp()), springMethodStat.getLastErrorMsg());
            if (++count != 10) continue;
            break;
        }
        String result = "<table style='width: 100%;'>";
        result = result + "<tr><td class='titleMin'>\u65f6\u95f4</td><td class='titleMin'>\u9519\u8bef\u4fe1\u606f(" + method + ")</td></tr>";
        for (Map.Entry entry : map.entrySet()) {
            result = result + "<tr>";
            result = result + "<td>" + (String)entry.getKey() + "</td>";
            result = result + "<td>" + (String)entry.getValue() + "</td>";
            result = result + "</tr>";
        }
        result = result + "</table>";
        return result;
    }
}

