/*
 * Decompiled with CFR 0.152.
 */
package cn.jmonitor.monitor4j.websupport.collector;

import cn.jmonitor.monitor4j.client.protocal.message.GetAttribute;
import cn.jmonitor.monitor4j.jmx.JMXUtils;
import cn.jmonitor.monitor4j.plugin.jvm.JVMInfo;
import cn.jmonitor.monitor4j.websupport.collector.BaseCollector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;

public class JvmCollector
extends BaseCollector {
    private static ArrayBlockingQueue<Map<String, Object>> memeoryQueue = new ArrayBlockingQueue(1440);
    private static ArrayBlockingQueue<Map<String, Object>> gcQueue = new ArrayBlockingQueue(1440);
    private static ArrayBlockingQueue<Map<String, Object>> threadQueue = new ArrayBlockingQueue(1440);
    private static JVMInfo jvmInfo = JVMInfo.getInstance();

    public static void doCollect() {
        GetAttribute memoryAttribute = new GetAttribute();
        memoryAttribute.setAttributeNames(Arrays.asList("HeapMemoryInit", "HeapMemoryMax", "HeapMemoryUsed", "NonHeapMemoryInit", "NonHeapMemoryMax", "NonHeapMemoryUsed", "PermGenMax", "PermGenUsed", "OldGenMax", "OldGenUsed", "EdenSpaceMax", "EdenSpaceUsed", "SurvivorMax", "SurvivorUsed"));
        memoryAttribute.setObjectName("cn.jmonitor.monitor4j:type=JVMMemory");
        Map memoryMap = (Map)JMXUtils.getAttributeFormatted(memoryAttribute);
        memoryMap.put("timeStamp", new Date());
        JvmCollector.checkQueueSize(memeoryQueue);
        memeoryQueue.offer(memoryMap);
        GetAttribute gcAttribute = new GetAttribute();
        gcAttribute.setAttributeNames(Arrays.asList("YoungGCCollectionCount", "YoungGCCollectionTime", "FullGCCollectionCount", "FullGCCollectionTime", "SpanYoungGCCollectionCount", "SpanYoungGCCollectionTime", "SpanFullGCCollectionCount", "SpanFullGCCollectionTime"));
        gcAttribute.setObjectName("cn.jmonitor.monitor4j:type=JVMGC");
        Map gcMap = (Map)JMXUtils.getAttributeFormatted(gcAttribute);
        gcMap.put("timeStamp", new Date());
        JvmCollector.checkQueueSize(gcQueue);
        gcQueue.offer(gcMap);
        GetAttribute threadAttribute = new GetAttribute();
        threadAttribute.setAttributeNames(Arrays.asList("DaemonThreadCount", "ThreadCount", "TotalStartedThreadCount", "DeadLockedThreadCount", "ProcessCpuTimeRate"));
        threadAttribute.setObjectName("cn.jmonitor.monitor4j:type=JVMThread");
        Map threadMap = (Map)JMXUtils.getAttributeFormatted(threadAttribute);
        threadMap.put("timeStamp", new Date());
        JvmCollector.checkQueueSize(threadQueue);
        threadQueue.offer(threadMap);
    }

    public static List<Map<String, Object>> getJvmMemoryModelList() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> model : memeoryQueue) {
            list.add(model);
        }
        return list;
    }

    public static List<Map<String, Object>> getJvmGCModelList() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> model : gcQueue) {
            list.add(model);
        }
        return list;
    }

    public static List<Map<String, Object>> getJvmThreadInfoList() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> model : threadQueue) {
            list.add(model);
        }
        return list;
    }

    public static String buildJvmInfoHtml() {
        String result = "<table>";
        result = result + "<tr><td class='name'>\u4e3b\u673a\u540d</td><td>" + jvmInfo.getHostname() + "</td></tr>";
        result = result + "<tr><td class='name'>IP</td><td>" + jvmInfo.getLocalIP() + "</td></tr>";
        result = result + "<tr><td class='name'>\u8fdb\u7a0bID</td><td>" + jvmInfo.getPID() + "</td></tr>";
        result = result + "<tr><td class='name'>\u542f\u52a8\u65f6\u95f4</td><td>" + BaseCollector.DateFormat.format(jvmInfo.getStartTime()) + "</td></tr>";
        result = result + "<tr><td class='name'>\u542f\u52a8\u53c2\u6570</td><td>" + jvmInfo.getInputArguments() + "</td></tr>";
        result = result + "<tr><td class='name'>\u786c\u4ef6\u5e73\u53f0</td><td>" + jvmInfo.getArch() + "</td></tr>";
        result = result + "<tr><td class='name'>\u53ef\u7528CPU\u4e2a\u6570</td><td>" + jvmInfo.getAvailableProcessors() + "</td></tr>";
        result = result + "<tr><td class='name'>\u64cd\u4f5c\u7cfb\u7edf</td><td>" + jvmInfo.getOSName() + "[" + jvmInfo.getOSVersion() + "]</td></tr>";
        result = result + "<tr><td class='name'>\u6587\u4ef6\u7f16\u7801</td><td>" + jvmInfo.getFileEncode() + "</td></tr>";
        result = result + "<tr><td class='name'>JVM\u540d\u79f0</td><td>" + jvmInfo.getJVM() + "</td></tr>";
        result = result + "<tr><td class='name'>JavaVersion</td><td>" + jvmInfo.getJavaVersion() + "</td></tr>";
        result = result + "<tr><td class='name'>JavaSpecVersion</td><td>" + jvmInfo.getJavaSpecificationVersion() + "</td></tr>";
        result = result + "<tr><td class='name'>JavaHome</td><td>" + jvmInfo.getJavaHome() + "</td></tr>";
        result = result + "<tr><td class='name'>JavaLibraryPath</td><td>" + jvmInfo.getJavaLibraryPath() + "</td></tr>";
        result = result + "<tr><td class='name'>\u5f53\u524d\u88c5\u8f7d\u7684\u7c7b\u603b\u6570</td><td>" + jvmInfo.getLoadedClassCount() + "</td></tr>";
        result = result + "<tr><td class='name'>\u603b\u5171\u88c5\u8f7d\u8fc7\u7684\u7c7b\u603b\u6570</td><td>" + jvmInfo.getTotalLoadedClassCount() + "</td></tr>";
        result = result + "<tr><td class='name'>\u5378\u8f7d\u7684\u7c7b\u603b\u6570</td><td>" + jvmInfo.getUnloadedClassCount() + "</td></tr>";
        result = result + "<tr><td class='name'>\u603b\u5171\u7f16\u8bd1\u65f6\u95f4</td><td>" + jvmInfo.getTotalCompilationTime() + "</td></tr>";
        result = result + "</table>";
        return result;
    }
}

