/*
 * Decompiled with CFR 0.152.
 */
package cn.jmonitor.monitor4j.websupport.collector;

import cn.jmonitor.monitor4j.client.protocal.message.GetAttribute;
import cn.jmonitor.monitor4j.jmx.JMXUtils;
import cn.jmonitor.monitor4j.utils.JsonUtils;
import cn.jmonitor.monitor4j.utils.StringUtils;
import cn.jmonitor.monitor4j.websupport.JmonitorDataComparator;
import cn.jmonitor.monitor4j.websupport.collector.BaseCollector;
import cn.jmonitor.monitor4j.websupport.items.LogInfo;
import cn.jmonitor.monitor4j.websupport.items.LogInfoKey;
import cn.jmonitor.monitor4j.websupport.items.LogInfoSingleInfoForWeb;
import cn.jmonitor.monitor4j.websupport.items.LogInfoStat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;

public class ExceptionCollector
extends BaseCollector {
    private static ArrayBlockingQueue<LogInfo> logInfoQueue = new ArrayBlockingQueue(1440);
    private static Map<Long, LogInfo> logInfoMap = new HashMap<Long, LogInfo>();

    public static void doCollect() {
        GetAttribute exceptionAttribute = new GetAttribute();
        exceptionAttribute.setAttributeNames(Arrays.asList("JmonitorDataList"));
        exceptionAttribute.setObjectName("cn.jmonitor.monitor4j:type=Exception");
        exceptionAttribute.setOptions(Arrays.asList("reset=true"));
        String exceptionMapStr = JsonUtils.toJsonString(JMXUtils.getAttributeFormatted(exceptionAttribute));
        List<LogInfoStat> logInfoStats = JsonUtils.parseArray(exceptionMapStr, LogInfoStat.class);
        LogInfo loginfo = new LogInfo();
        for (LogInfoStat logInfoStat : logInfoStats) {
            loginfo.getLogMap().put(logInfoStat.buildLogInfoKey(), logInfoStat);
        }
        loginfo.setTimeStamp(new Date());
        logInfoMap.put(loginfo.getTimeStamp().getTime(), loginfo);
        ExceptionCollector.checkQueueSize(logInfoQueue);
        logInfoQueue.offer(loginfo);
    }

    public static String getLogInfoForHtml(Integer timeInterval) {
        if (null == timeInterval) {
            throw new IllegalArgumentException("timeInterval can not be null!");
        }
        HashMap<LogInfoKey, LogInfoStat> map = new HashMap<LogInfoKey, LogInfoStat>();
        int count = 0;
        for (LogInfo logInfo : logInfoQueue) {
            ExceptionCollector.mergeLogInfoMap(map, logInfo.getLogMap());
            if (++count != timeInterval) continue;
            break;
        }
        String result = "<table style='width: 94%;'>";
        result = result + "<tr><td class='title'>\u5f02\u5e38\u7c7b\u578b(count:" + map.size() + ")</td><td class='title'>\u5f02\u5e38\u65b9\u6cd5</td><td class='titleMin'>\u603b\u6570</td></tr>";
        ArrayList logInfoStatList = new ArrayList(map.values());
        Collections.sort(logInfoStatList, new JmonitorDataComparator("count", "DESC"));
        for (LogInfoStat entry : logInfoStatList) {
            result = result + "<tr>";
            result = result + "<td>" + entry.getType() + "</td>";
            result = result + "<td>" + entry.getMethod() + "</td>";
            result = result + "<td><a href='#' onclick='showLogInfoDetail(\"" + entry.getType() + "\",\"" + entry.getMethod() + "\")'>" + entry.getCount() + "</a></td>";
            result = result + "</tr>";
        }
        result = result + "</table>";
        return result;
    }

    private static void mergeLogInfoMap(Map<LogInfoKey, LogInfoStat> resultMap, Map<LogInfoKey, LogInfoStat> targetMap) {
        if (null == resultMap || null == targetMap) {
            return;
        }
        for (Map.Entry<LogInfoKey, LogInfoStat> entry : targetMap.entrySet()) {
            LogInfoStat logInfoStat = resultMap.get(entry.getKey());
            if (null == logInfoStat) {
                logInfoStat = new LogInfoStat();
                logInfoStat.setType(entry.getKey().getExceptionType());
                logInfoStat.setMethod(entry.getKey().getMethodName());
                resultMap.put(entry.getKey(), logInfoStat);
            }
            logInfoStat.setCount(logInfoStat.getCount() + entry.getValue().getCount());
        }
    }

    public static String getLogInfoStrackTraceForHtml(String exceptionType, String methodName, Long timestamp) {
        if (null == timestamp) {
            throw new IllegalArgumentException("timestamp can not be null!");
        }
        LogInfoKey logInfoKey = new LogInfoKey(exceptionType, methodName);
        LogInfo logInfo = logInfoMap.get(timestamp);
        LogInfoStat logInfoStat = logInfo.getLogMap().get(logInfoKey);
        String lastStackTrace = logInfoStat.getLastStackTrace();
        if (StringUtils.isNotBlank(lastStackTrace)) {
            lastStackTrace = lastStackTrace.replaceAll("\r\n", "<br>");
            lastStackTrace = lastStackTrace.replaceAll(" ", "");
        }
        String result = "<table style='width: 100%;'>";
        result = result + "<tr><td class='namemin'>\u5f02\u5e38\u7c7b\u578b</td><td>" + exceptionType + "</td></tr>";
        result = result + "<tr><td class='namemin'>\u5f02\u5e38\u65b9\u6cd5</td><td>" + methodName + "</td></tr>";
        result = result + "<tr><td class='namemin'>\u5f02\u5e38\u6570\u91cf</td><td>" + logInfoStat.getCount() + "</td></tr>";
        result = result + "<tr><td class='namemin'>\u6700\u540e\u65f6\u95f4</td><td>" + DateFormat.format(logInfoStat.getLastDate()) + "</td></tr>";
        result = result + "<tr><td class='namemin'>\u6700\u540e\u5f02\u5e38\u4fe1\u606f</td><td>" + logInfoStat.getLastMessage() + "</td></tr>";
        result = result + "<tr><td class='namemin'>\u6700\u540e\u5f02\u5e38\u5806\u6808</td><td>" + lastStackTrace + "</td></tr>";
        result = result + "</table>";
        return result;
    }

    public static List<LogInfoSingleInfoForWeb> getLogInfoSingleInfoForWebList(String exceptionType, String methodName) {
        ArrayList<LogInfoSingleInfoForWeb> result = new ArrayList<LogInfoSingleInfoForWeb>();
        LogInfoKey logInfoKey = new LogInfoKey(exceptionType, methodName);
        for (LogInfo logInfo : logInfoQueue) {
            LogInfoStat logInfoStat = logInfo.getLogMap().get(logInfoKey);
            if (null == logInfoStat) continue;
            LogInfoSingleInfoForWeb singleInfoForWeb = new LogInfoSingleInfoForWeb();
            singleInfoForWeb.setCount(logInfoStat.getCount());
            singleInfoForWeb.setTimeStamp(logInfo.getTimeStamp());
            result.add(singleInfoForWeb);
        }
        return result;
    }
}

