/*
 * Decompiled with CFR 0.152.
 */
package cn.jmonitor.monitor4j.websupport;

import cn.jmonitor.monitor4j.utils.IOUtils;
import cn.jmonitor.monitor4j.websupport.MonitorWebDataFacade;
import java.io.IOException;
import java.util.Date;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MonitorWebViewFilter
implements Filter {
    private static final String RESOURCE_PATH = "support";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        String path;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        String contextPath = request.getContextPath();
        String servletPath = request.getServletPath();
        response.setCharacterEncoding("utf-8");
        if (contextPath == null) {
            contextPath = "";
        }
        String uri = contextPath + servletPath;
        if (servletPath.startsWith("/")) {
            String tmpServletPath = servletPath.substring(1);
            path = tmpServletPath.substring(tmpServletPath.indexOf("/"));
        } else {
            path = servletPath.substring(servletPath.indexOf("/"));
        }
        if ("".equals(path)) {
            response.setContentType("text/html;charset=utf-8");
            response.getWriter().println(new Date());
            response.flushBuffer();
            return;
        }
        if (path.endsWith(".do")) {
            MonitorWebDataFacade.jsonDataDispather(request, response, path);
            return;
        }
        this.returnResourceFile(path, uri, response);
    }

    public void destroy() {
    }

    private void returnResourceFile(String fileName, String uri, HttpServletResponse response) throws ServletException, IOException {
        if (fileName.endsWith(".jpg") || fileName.endsWith(".png")) {
            byte[] bytes = IOUtils.readByteArrayFromResource(RESOURCE_PATH + fileName);
            if (bytes != null) {
                response.getOutputStream().write(bytes);
            }
            return;
        }
        String text = IOUtils.readFromResource(RESOURCE_PATH + fileName);
        if (text == null) {
            response.getWriter().write("error url");
            response.flushBuffer();
            return;
        }
        if (fileName.endsWith(".html")) {
            response.setContentType("text/html;charset=utf-8");
        } else if (fileName.endsWith(".css")) {
            response.setContentType("text/css;charset=utf-8");
        } else if (fileName.endsWith(".js")) {
            response.setContentType("text/javascript;charset=utf-8");
        }
        response.getWriter().write(text);
    }
}

