/*
 * Decompiled with CFR 0.152.
 */
package cn.jmonitor.monitor4j.utils;

import cn.jmonitor.monitor4j.exception.AlimonitorJmonitorException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;

public class IPUtils {
    private static Collection<InetAddress> getAllHostAddress() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    addresses.add(inetAddress);
                }
            }
            return addresses;
        }
        catch (SocketException e) {
            throw new AlimonitorJmonitorException(e.getMessage(), e);
        }
    }

    public static Collection<String> getAllIpv4NoLoopbackAddresses() {
        ArrayList<String> noLoopbackAddresses = new ArrayList<String>();
        Collection<InetAddress> allInetAddresses = IPUtils.getAllHostAddress();
        for (InetAddress address : allInetAddresses) {
            if (address.isLoopbackAddress() || !(address instanceof Inet4Address)) continue;
            noLoopbackAddresses.add(address.getHostAddress());
        }
        return noLoopbackAddresses;
    }

    public static String getFirstNoLoopbackAddress() {
        Collection<String> allNoLoopbackAddresses = IPUtils.getAllIpv4NoLoopbackAddresses();
        return allNoLoopbackAddresses.iterator().next();
    }

    public static String getLocalHostName() {
        try {
            InetAddress netAddress = InetAddress.getLocalHost();
            return netAddress.getHostName();
        }
        catch (UnknownHostException e) {
            return "";
        }
    }

    public static String getLocalIp() {
        try {
            InetAddress netAddress = InetAddress.getLocalHost();
            return netAddress.getHostAddress();
        }
        catch (UnknownHostException e) {
            return "";
        }
    }

    public static void main(String[] args) {
        System.out.println(IPUtils.getAllIpv4NoLoopbackAddresses());
        System.out.println(IPUtils.getLocalHostName());
    }
}

