/*
 * Decompiled with CFR 0.152.
 */
package cn.jmonitor.monitor4j.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileUtils {
    private static final Log LOG = LogFactory.getLog(FileUtils.class);
    private static final String jmonitorConfigLogHome = System.getProperty("user.home") + "/logs/jmonitor.log";

    public static void appendToLog(String log) {
        FileUtils.saveSelfLog(new Date() + ":" + log, true);
    }

    private static void saveSelfLog(String log, boolean append) {
        try {
            FileUtils.writeStringToFile(new File(jmonitorConfigLogHome), log + "\n", Charset.forName("UTF-8"), append);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(File file, String data, Charset encoding, boolean append) throws IOException {
        FileOutputStream out = null;
        try {
            out = FileUtils.openOutputStream(file, append);
            FileUtils.write(data, out, encoding);
            ((OutputStream)out).close();
        }
        finally {
            FileUtils.closeQuietly(out);
        }
    }

    public static void closeQuietly(OutputStream output) {
        FileUtils.closeQuietly((Closeable)output);
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void write(String data, OutputStream output, Charset encoding) throws IOException {
        if (data != null) {
            output.write(data.getBytes(encoding));
        }
    }

    public static FileOutputStream openOutputStream(File file, boolean append) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canWrite()) {
                throw new IOException("File '" + file + "' cannot be written to");
            }
        } else {
            File parent = file.getParentFile();
            if (parent != null && !parent.mkdirs() && !parent.isDirectory()) {
                throw new IOException("Directory '" + parent + "' could not be created");
            }
        }
        return new FileOutputStream(file, append);
    }

    static {
        FileUtils.saveSelfLog("start:" + new Date(), false);
    }
}

