/*
 * Decompiled with CFR 0.152.
 */
package cn.jmonitor.monitor4j.server;

import cn.jmonitor.monitor4j.client.protocal.message.BaseMessage;
import cn.jmonitor.monitor4j.client.protocal.message.GetAttribute;
import cn.jmonitor.monitor4j.client.protocal.tlv.TLVMessage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;

public class AgentServerMock {
    private static final Log LOG = LogFactory.getLog(AgentServerMock.class);
    public static final short TEXT_UTF_8 = 1;
    private static BlockingQueue<BaseMessage> sendQueue = new ArrayBlockingQueue<BaseMessage>(100);
    private Object writerLock = new Object();
    private Object closeLock = new Object();
    private static final int AGENT_PORT = 19777;

    public static void main1(String[] args) {
        String line = "jmx://GetAttr/cn.jmonitor.monitor4j:type=JVMMemory(\"MemoryHeapMax\",\"MemoryHeapMax11\")";
        line = line.substring("jmx://GetAttr/".length());
        GetAttribute getAttribute = new GetAttribute();
        getAttribute.setObjectName(line.substring(0, line.indexOf(40)));
        String attributeNames = line.substring(line.indexOf(40) + 1, line.indexOf(41));
        ArrayList<String> attrList = new ArrayList<String>();
        for (String s : attributeNames.split(",")) {
            attrList.add(s.substring(1, s.length() - 1));
        }
        getAttribute.setAttributeNames(attrList);
        int indexOfOption = line.indexOf(63);
        if (indexOfOption != -1) {
            ArrayList<String> optionList = new ArrayList<String>();
            String option = line.substring(indexOfOption + 1);
            for (String optionItem : option.split("&")) {
                optionList.add(optionItem);
            }
            getAttribute.setOptions(optionList);
        }
        System.out.println(getAttribute.getObjectName());
        System.out.println(getAttribute.getAttributeNames());
        System.out.println(getAttribute.getOptions());
    }

    public static void main(String[] args) throws Exception {
        PropertyConfigurator.configure((String)"D:/log4j.properties");
        new Thread(new Runnable(){

            @Override
            public void run() {
                Scanner scanner = new Scanner(System.in);
                while (true) {
                    try {
                        while (true) {
                            String line = scanner.nextLine();
                            line = line.substring("jmx://GetAttr/".length());
                            GetAttribute getAttribute = new GetAttribute();
                            getAttribute.setObjectName(line.substring(0, line.indexOf(40)));
                            String attributeNames = line.substring(line.indexOf(40) + 1, line.indexOf(41));
                            ArrayList<String> attrList = new ArrayList<String>();
                            for (String s : attributeNames.split(",")) {
                                attrList.add(s.substring(1, s.length() - 1));
                            }
                            getAttribute.setAttributeNames(attrList);
                            int indexOfOption = line.indexOf(63);
                            if (indexOfOption != -1) {
                                ArrayList<String> optionList = new ArrayList<String>();
                                String option = line.substring(indexOfOption + 1);
                                for (String optionItem : option.split("&")) {
                                    optionList.add(optionItem);
                                }
                                getAttribute.setOptions(optionList);
                            }
                            sendQueue.offer(getAttribute);
                        }
                    }
                    catch (Exception e) {
                        scanner.close();
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
        }).start();
        AgentServerMock agentServerMock = new AgentServerMock();
        agentServerMock.start();
    }

    public void start() throws Exception {
        ServerSocket serverSocket = new ServerSocket(19777);
        System.out.println("agent server started,port:19777");
        while (true) {
            try {
                while (true) {
                    Socket socket = serverSocket.accept();
                    LOG.info((Object)("client connect:" + socket.getPort()));
                    this.handleSocket(socket);
                }
            }
            catch (Exception e) {
                serverSocket.close();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(DataOutputStream writer, DataInputStream reader, Socket socket) {
        Object object = this.closeLock;
        synchronized (object) {
            try {
                if (reader != null) {
                    reader.close();
                    reader = null;
                }
                if (writer != null) {
                    writer.close();
                    writer = null;
                }
                if (socket != null) {
                    socket.close();
                    socket = null;
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void handleSocket(final Socket socket) throws IOException {
        final DataInputStream reader = new DataInputStream(socket.getInputStream());
        final DataOutputStream writer = new DataOutputStream(socket.getOutputStream());
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (null != reader) {
                        short type = reader.readShort();
                        int length = reader.readInt();
                        byte[] value = new byte[length];
                        reader.readFully(value);
                        TLVMessage tlvMessage = new TLVMessage(type, length, value);
                        LOG.info((Object)("reader:" + new String(tlvMessage.getValue(), "UTF-8")));
                    }
                }
                catch (Exception e) {
                    AgentServerMock.this.close(writer, reader, socket);
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (null != writer) {
                        BaseMessage message = (BaseMessage)sendQueue.take();
                        AgentServerMock.this.sendMsgDirect(writer, message);
                        LOG.info((Object)("writer:" + message.buildMsg()));
                    }
                }
                catch (Exception e) {
                    AgentServerMock.this.close(writer, reader, socket);
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMsgDirect(DataOutputStream writer, BaseMessage message) throws IOException {
        Object object = this.writerLock;
        synchronized (object) {
            if (null == writer) {
                return;
            }
            byte[] bytes = message.buildMsgByte();
            writer.writeShort(1);
            writer.writeInt(bytes.length);
            writer.write(bytes);
            writer.flush();
        }
    }
}

