/*
 * Decompiled with CFR 0.152.
 */
package cn.jmonitor.monitor4j.plugin.web.profile;

import cn.jmonitor.monitor4j.plugin.spring.SpringMethodItemKey;
import cn.jmonitor.monitor4j.plugin.spring.SpringMethodItemValue;
import cn.jmonitor.monitor4j.plugin.web.profile.WebUrlProfileDataManagerMBean;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.JMException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public class WebUrlProfileDataManager
implements WebUrlProfileDataManagerMBean {
    private static WebUrlProfileDataManager instance = new WebUrlProfileDataManager();
    private final AtomicLong resetCount = new AtomicLong();
    private final ConcurrentMap<String, ConcurrentMap<SpringMethodItemKey, SpringMethodItemValue>> profileSpringDataMap = new ConcurrentHashMap<String, ConcurrentMap<SpringMethodItemKey, SpringMethodItemValue>>();
    private static CompositeType COMPOSITE_TYPE = null;

    public static final WebUrlProfileDataManager getInstance() {
        return instance;
    }

    private WebUrlProfileDataManager() {
    }

    public ConcurrentMap<String, ConcurrentMap<SpringMethodItemKey, SpringMethodItemValue>> getProfileSpringDataMap() {
        return this.profileSpringDataMap;
    }

    @Override
    public long getResetCount() {
        return this.resetCount.get();
    }

    @Override
    public void reset() {
        this.resetCount.incrementAndGet();
        this.profileSpringDataMap.clear();
    }

    @Override
    public TabularData getJmonitorDataList() throws JMException {
        CompositeType rowType = WebUrlProfileDataManager.getCompositeType();
        String[] indexNames = rowType.keySet().toArray(new String[rowType.keySet().size()]);
        TabularType tabularType = new TabularType("WebProfileList", "WebProfileList", rowType, indexNames);
        TabularDataSupport data = new TabularDataSupport(tabularType);
        for (Map.Entry entry : this.profileSpringDataMap.entrySet()) {
            for (Map.Entry subEntry : ((ConcurrentMap)entry.getValue()).entrySet()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("URL", entry.getKey());
                map.put("Name", ((SpringMethodItemKey)subEntry.getKey()).getClassName() + "." + ((SpringMethodItemKey)subEntry.getKey()).getMethod());
                map.put("Type", ProfileType.spring.toString());
                map.put("Count", ((SpringMethodItemValue)subEntry.getValue()).getInvokCount());
                map.put("ConcurrentMax", ((SpringMethodItemValue)subEntry.getValue()).getConcurrentMax());
                map.put("RunningCount", ((SpringMethodItemValue)subEntry.getValue()).getRunningCount());
                map.put("NanoTotal", ((SpringMethodItemValue)subEntry.getValue()).getNanoTotal());
                map.put("NanoMax", ((SpringMethodItemValue)subEntry.getValue()).getNanoMax());
                map.put("ErrorCount", ((SpringMethodItemValue)subEntry.getValue()).getErrorCount());
                map.put("LastErrorMessage", ((SpringMethodItemValue)subEntry.getValue()).getLastErrorMessage());
                map.put("LastErrorTime", ((SpringMethodItemValue)subEntry.getValue()).getLastErrorTime());
                data.put(new CompositeDataSupport(WebUrlProfileDataManager.getCompositeType(), map));
            }
        }
        return data;
    }

    public static CompositeType getCompositeType() throws JMException {
        String[] indexNames;
        if (COMPOSITE_TYPE != null) {
            return COMPOSITE_TYPE;
        }
        OpenType[] indexTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.STRING, SimpleType.DATE};
        String[] indexDescriptions = indexNames = new String[]{"URL", "Name", "Type", "Count", "ConcurrentMax", "RunningCount", "NanoTotal", "NanoMax", "ErrorCount", "LastErrorMessage", "LastErrorTime"};
        COMPOSITE_TYPE = new CompositeType("WebProfileList", "web profile list", indexNames, indexDescriptions, indexTypes);
        return COMPOSITE_TYPE;
    }

    private static enum ProfileType {
        ibatis,
        spring;

    }
}

