/*
 * Decompiled with CFR 0.152.
 */
package cn.jmonitor.monitor4j.plugin.web;

import cn.jmonitor.monitor4j.plugin.web.WebEntryLocal;
import cn.jmonitor.monitor4j.plugin.web.WebUrlDataManager;
import cn.jmonitor.monitor4j.plugin.web.WebUrlItem;
import cn.jmonitor.monitor4j.utils.StringUtils;

public class WebUrlDataCalHelper {
    private static final WebUrlDataManager webUrlDataManager = WebUrlDataManager.getInstance();
    private static int maxCount = 2000;
    public static ThreadLocal<WebEntryLocal> currentWebEntry = new ThreadLocal();

    public static boolean isFull() {
        return webUrlDataManager.getWebUrlMap().size() > maxCount;
    }

    public static void handleBefore(String url) {
        if (StringUtils.isBlank(url)) {
            return;
        }
        if (webUrlDataManager.getWebUrlMap().size() > maxCount) {
            return;
        }
        WebUrlItem webUrlItem = (WebUrlItem)webUrlDataManager.getWebUrlMap().get(url);
        if (null == webUrlItem) {
            webUrlItem = new WebUrlItem(url);
            webUrlDataManager.getWebUrlMap().put(url, webUrlItem);
        }
        webUrlItem.incrementRunningCount();
        WebEntryLocal entryLocal = new WebEntryLocal(url, System.nanoTime());
        entryLocal.setWebUrlItem(webUrlItem);
        currentWebEntry.set(entryLocal);
    }

    public static void handleException(boolean hasError, String errorMsg) {
        WebEntryLocal webEntryLocal = currentWebEntry.get();
        if (null == webEntryLocal) {
            return;
        }
        webEntryLocal.setHasError(hasError);
        webEntryLocal.setErrorMsg(errorMsg);
    }

    public static void handleAfter() {
        WebEntryLocal webEntryLocal = currentWebEntry.get();
        if (null == webEntryLocal) {
            return;
        }
        WebUrlItem webUrlItem = webEntryLocal.getWebUrlItem();
        long startNano = webEntryLocal.getStartTime();
        boolean error = webEntryLocal.isHasError();
        String errorMsg = webEntryLocal.getErrorMsg();
        if (webUrlItem != null) {
            webUrlItem.handleAfter(startNano, error, errorMsg);
        }
        currentWebEntry.set(null);
    }

    public static void setMaxCount(int maxCount) {
        WebUrlDataCalHelper.maxCount = maxCount;
    }
}

