/*
 * Decompiled with CFR 0.152.
 */
package cn.jmonitor.monitor4j.plugin.web;

import cn.jmonitor.monitor4j.common.JmonitorConstants;
import cn.jmonitor.monitor4j.plugin.web.WebIPDataCalHelper;
import cn.jmonitor.monitor4j.plugin.web.WebUrlDataCalHelper;
import cn.jmonitor.monitor4j.utils.FileUtils;
import cn.jmonitor.monitor4j.utils.WebUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class JMonitorWebFilter
implements Filter {
    private final List<String> exclusions = new ArrayList<String>();

    public void init(FilterConfig filterConfig) throws ServletException {
        int maxCount;
        String maxCountStr;
        String paramExclusions = filterConfig.getInitParameter("exclusions");
        if (paramExclusions != null) {
            String[] items;
            for (String item : items = paramExclusions.split(",")) {
                if (item == null || item.length() == 0) continue;
                this.exclusions.add(item);
            }
        }
        if (null != (maxCountStr = filterConfig.getInitParameter("maxCount")) && (maxCount = Integer.valueOf(maxCountStr).intValue()) > 0) {
            WebUrlDataCalHelper.setMaxCount(maxCount);
            WebIPDataCalHelper.setMaxCount(maxCount);
        }
    }

    public String getRequestURI(HttpServletRequest request) {
        return request.getRequestURI();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (WebUrlDataCalHelper.isFull()) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String url = this.getRequestURI(httpServletRequest);
        if (this.isExclusion(url)) {
            chain.doFilter(request, response);
            return;
        }
        WebUrlDataCalHelper.handleBefore(url);
        if (JmonitorConstants.enableMonitorIp) {
            String ip = WebUtils.getClientAddress(httpServletRequest);
            WebIPDataCalHelper.handleBefore(ip);
        }
        boolean hasError = false;
        String errorMsg = null;
        try {
            chain.doFilter((ServletRequest)httpServletRequest, response);
        }
        catch (ServletException ex) {
            hasError = true;
            errorMsg = ex.getMessage();
            throw ex;
        }
        catch (IOException ex) {
            hasError = true;
            errorMsg = ex.getMessage();
            throw ex;
        }
        catch (RuntimeException ex) {
            hasError = true;
            errorMsg = ex.getMessage();
            throw ex;
        }
        catch (Error ex) {
            hasError = true;
            errorMsg = ex.getMessage();
            throw ex;
        }
        finally {
            WebUrlDataCalHelper.handleException(hasError, errorMsg);
            WebUrlDataCalHelper.handleAfter();
            WebIPDataCalHelper.handleException(hasError, errorMsg);
            WebIPDataCalHelper.handleAfter();
        }
    }

    public void destroy() {
    }

    private boolean isExclusion(String uri) {
        for (String exclusion : this.exclusions) {
            if (!uri.endsWith(exclusion)) continue;
            return true;
        }
        return false;
    }

    static {
        FileUtils.appendToLog("cn.jmonitor.monitor4j.plugin.web.JMonitorWebFilter started.");
    }
}

