/*
 * Decompiled with CFR 0.152.
 */
package cn.jmonitor.monitor4j.plugin.spring;

import cn.jmonitor.monitor4j.plugin.spring.SpringMethodItemKey;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.JMException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class SpringMethodItemValue {
    private SpringMethodItemKey springMethodItemKey;
    private final AtomicInteger runningCount = new AtomicInteger(0);
    private final AtomicInteger concurrentMax = new AtomicInteger(0);
    private final AtomicLong count = new AtomicLong(0L);
    private final AtomicLong errorCount = new AtomicLong(0L);
    private final AtomicLong nanoTotal = new AtomicLong(0L);
    private final AtomicLong nanoMax = new AtomicLong(0L);
    private String lastErrorMessage = "";
    private String LastErrorStackTrace = "";
    private Date lastErrorTime;
    private static CompositeType COMPOSITE_TYPE = null;

    public SpringMethodItemValue(SpringMethodItemKey springMethodItemKey) {
        this.springMethodItemKey = springMethodItemKey;
    }

    public void incrementRunningCount() {
        this.runningCount.incrementAndGet();
    }

    public void handleAfter(long startNano, boolean error, String errorMsg, String errorSackTrace) {
        long nanoMaxNow;
        long nanoUseNow;
        this.count.incrementAndGet();
        int runningCountNow = this.getRunningCount();
        int concurrentMaxNow = this.getConcurrentMax();
        if (runningCountNow > concurrentMaxNow) {
            this.concurrentMax.compareAndSet(concurrentMaxNow, runningCountNow);
        }
        if ((nanoUseNow = System.nanoTime() - startNano) > (nanoMaxNow = this.getNanoMax())) {
            this.nanoMax.compareAndSet(nanoMaxNow, nanoUseNow);
        }
        this.runningCount.decrementAndGet();
        this.nanoTotal.addAndGet(nanoUseNow);
        if (error) {
            this.errorCount.incrementAndGet();
            this.lastErrorMessage = errorMsg;
            this.LastErrorStackTrace = errorSackTrace;
            this.lastErrorTime = new Date();
        }
    }

    public void cleardata() {
        this.concurrentMax.set(this.getRunningCount());
        this.count.set(0L);
        this.errorCount.set(0L);
        this.nanoTotal.set(0L);
        this.nanoMax.set(0L);
        this.lastErrorMessage = "";
        this.LastErrorStackTrace = "";
        this.lastErrorTime = null;
    }

    public CompositeData getCompositeData() throws JMException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Class", this.springMethodItemKey.getClassName());
        map.put("Method", this.springMethodItemKey.getMethod());
        map.put("Count", this.getInvokCount());
        map.put("ConcurrentMax", this.getConcurrentMax());
        map.put("RunningCount", this.getRunningCount());
        map.put("NanoTotal", this.getNanoTotal());
        map.put("NanoMax", this.getNanoMax());
        map.put("ErrorCount", this.getErrorCount());
        map.put("LastErrorMessage", this.getLastErrorMessage());
        map.put("LastErrorStackTrace", this.getLastErrorStackTrace());
        map.put("LastErrorTime", this.getLastErrorTime());
        return new CompositeDataSupport(SpringMethodItemValue.getCompositeType(), map);
    }

    public static CompositeType getCompositeType() throws JMException {
        String[] indexNames;
        if (COMPOSITE_TYPE != null) {
            return COMPOSITE_TYPE;
        }
        OpenType[] indexTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.STRING, SimpleType.STRING, SimpleType.DATE};
        String[] indexDescriptions = indexNames = new String[]{"Class", "Method", "Count", "ConcurrentMax", "RunningCount", "NanoTotal", "NanoMax", "ErrorCount", "LastErrorMessage", "LastErrorStackTrace", "LastErrorTime"};
        COMPOSITE_TYPE = new CompositeType("MethodListStatistic", "Spring Method Statistic", indexNames, indexDescriptions, indexTypes);
        return COMPOSITE_TYPE;
    }

    public SpringMethodItemKey getSpringMethodItemKey() {
        return this.springMethodItemKey;
    }

    public int getRunningCount() {
        return this.runningCount.get();
    }

    public int getConcurrentMax() {
        return this.concurrentMax.get();
    }

    public long getInvokCount() {
        return this.count.get();
    }

    public long getErrorCount() {
        return this.errorCount.get();
    }

    public long getNanoTotal() {
        return this.nanoTotal.get();
    }

    public long getNanoMax() {
        return this.nanoMax.get();
    }

    public String getLastErrorMessage() {
        return this.lastErrorMessage;
    }

    public Date getLastErrorTime() {
        return this.lastErrorTime;
    }

    public String getLastErrorStackTrace() {
        return this.LastErrorStackTrace;
    }
}

