/*
 * Decompiled with CFR 0.152.
 */
package cn.jmonitor.monitor4j.plugin.spring;

import cn.jmonitor.monitor4j.plugin.spring.SpringMethodDataManagerMBean;
import cn.jmonitor.monitor4j.plugin.spring.SpringMethodItemKey;
import cn.jmonitor.monitor4j.plugin.spring.SpringMethodItemValue;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.JMException;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public class SpringMethodDataManager
implements SpringMethodDataManagerMBean {
    private static SpringMethodDataManager instance = new SpringMethodDataManager();
    private final AtomicLong resetCount = new AtomicLong();
    private final ConcurrentMap<SpringMethodItemKey, SpringMethodItemValue> dataMap = new ConcurrentHashMap<SpringMethodItemKey, SpringMethodItemValue>();
    private static Date lastRestTime;

    private SpringMethodDataManager() {
    }

    public static final SpringMethodDataManager getInstance() {
        return instance;
    }

    public ConcurrentMap<SpringMethodItemKey, SpringMethodItemValue> getDataMap() {
        return this.dataMap;
    }

    @Override
    public TabularData getJmonitorDataList() throws JMException {
        CompositeType rowType = SpringMethodItemValue.getCompositeType();
        String[] indexNames = rowType.keySet().toArray(new String[rowType.keySet().size()]);
        TabularType tabularType = new TabularType("MethodList", "MethodList", rowType, indexNames);
        TabularDataSupport data = new TabularDataSupport(tabularType);
        for (SpringMethodItemValue itemValue : this.dataMap.values()) {
            if (itemValue.getInvokCount() == 0L) continue;
            data.put(itemValue.getCompositeData());
        }
        return data;
    }

    @Override
    public long getResetCount() {
        return this.resetCount.get();
    }

    @Override
    public void reset() {
        this.resetCount.incrementAndGet();
        Iterator iterator = this.dataMap.values().iterator();
        while (iterator.hasNext()) {
            SpringMethodItemValue itemValue = (SpringMethodItemValue)iterator.next();
            if (itemValue.getRunningCount() == 0) {
                iterator.remove();
                continue;
            }
            itemValue.cleardata();
        }
        lastRestTime = new Date();
    }

    @Override
    public Date getLastResetTime() {
        return lastRestTime;
    }
}

