/*
 * Decompiled with CFR 0.152.
 */
package cn.jmonitor.monitor4j.plugin.log4j;

import cn.jmonitor.monitor4j.plugin.log4j.LogItemKey;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.JMException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class LogItemValue {
    private final AtomicLong count = new AtomicLong();
    private LogItemKey logItemKey;
    private Date lastDate;
    private String lastMessage;
    private String lastStackTrace;
    private static CompositeType COMPOSITE_TYPE = null;

    public LogItemValue(LogItemKey logItemKey) {
        this.logItemKey = logItemKey;
    }

    public Date getLastDate() {
        return this.lastDate;
    }

    public String getLastMessage() {
        return this.lastMessage;
    }

    public void setLastMessage(String lastMessage) {
        this.lastMessage = lastMessage;
    }

    public String getLastStackTrace() {
        return this.lastStackTrace;
    }

    public void setLastStackTrace(String lastStackTrace) {
        this.lastStackTrace = lastStackTrace;
    }

    public long getCount() {
        return this.count.get();
    }

    public void incrementCount() {
        this.lastDate = new Date();
        this.count.incrementAndGet();
    }

    public CompositeDataSupport getCompositeData() throws JMException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Type", this.logItemKey.getExceptionType());
        map.put("Method", this.logItemKey.getMethodName());
        map.put("StackTrace", this.getLastStackTrace());
        map.put("Count", this.getCount());
        map.put("LastThrowDate", this.getLastDate());
        map.put("LastThrowMessage", this.getLastMessage());
        return new CompositeDataSupport(LogItemValue.getCompositeType(), map);
    }

    public static CompositeType getCompositeType() throws JMException {
        String[] indexNames;
        if (COMPOSITE_TYPE != null) {
            return COMPOSITE_TYPE;
        }
        OpenType[] indexTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.DATE, SimpleType.STRING};
        String[] indexDescriptions = indexNames = new String[]{"Type", "Method", "StackTrace", "Count", "LastThrowDate", "LastThrowMessage"};
        COMPOSITE_TYPE = new CompositeType("ExceptionStatistic", "Exception Statistic", indexNames, indexDescriptions, indexTypes);
        return COMPOSITE_TYPE;
    }
}

