/*
 * Decompiled with CFR 0.152.
 */
package cn.jmonitor.monitor4j.plugin.log4j;

import cn.jmonitor.monitor4j.plugin.log4j.Log4jDataManagerMBean;
import cn.jmonitor.monitor4j.plugin.log4j.LogItemKey;
import cn.jmonitor.monitor4j.plugin.log4j.LogItemValue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.JMException;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public class Log4jDataManager
implements Log4jDataManagerMBean {
    private static Log4jDataManager instance = new Log4jDataManager();
    private final AtomicLong resetCount = new AtomicLong();
    private final ConcurrentMap<LogItemKey, LogItemValue> logMap = new ConcurrentHashMap<LogItemKey, LogItemValue>();
    private String logConfig;

    public static final Log4jDataManager getInstance() {
        return instance;
    }

    private Log4jDataManager() {
    }

    @Override
    public void reset() {
        this.resetCount.incrementAndGet();
        this.logMap.clear();
    }

    @Override
    public long getResetCount() {
        return this.resetCount.get();
    }

    @Override
    public TabularData getJmonitorDataList() throws JMException {
        CompositeType rowType = LogItemValue.getCompositeType();
        String[] indexNames = rowType.keySet().toArray(new String[rowType.keySet().size()]);
        TabularType tabularType = new TabularType("ErrorList", "ErrorList", rowType, indexNames);
        TabularDataSupport data = new TabularDataSupport(tabularType);
        for (LogItemValue logItemValue : this.logMap.values()) {
            data.put(logItemValue.getCompositeData());
        }
        return data;
    }

    public ConcurrentMap<LogItemKey, LogItemValue> getLogMap() {
        return this.logMap;
    }

    @Override
    public String getLogConfig() {
        return this.logConfig;
    }

    public void setLogConfig(String logConfig) {
        this.logConfig = logConfig;
    }
}

