/*
 * Decompiled with CFR 0.152.
 */
package cn.jmonitor.monitor4j.plugin.log4j;

import cn.jmonitor.monitor4j.plugin.log4j.Log4jDataManager;
import cn.jmonitor.monitor4j.plugin.log4j.LogItemKey;
import cn.jmonitor.monitor4j.plugin.log4j.LogItemValue;
import cn.jmonitor.monitor4j.utils.FileUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class JMonitorLog4jAppender
extends AppenderSkeleton {
    private final Log4jDataManager log4jDataManager = Log4jDataManager.getInstance();
    private boolean enableNoStackTrace = true;
    private int maxCount = 2000;
    private int maxStackTraceLength = 2000;

    protected void append(LoggingEvent event) {
        try {
            if (null == this.log4jDataManager.getLogConfig()) {
                this.log4jDataManager.setLogConfig("enableNoStackTrace:" + this.enableNoStackTrace + " ,maxCount:" + this.maxCount);
            }
            if (!Level.ERROR.equals((Object)event.getLevel())) {
                return;
            }
            if (this.log4jDataManager.getLogMap().size() > this.maxCount) {
                return;
            }
            ThrowableInformation errorInfo = event.getThrowableInformation();
            if (null == errorInfo && !this.enableNoStackTrace) {
                return;
            }
            LocationInfo locationInfo = event.getLocationInformation();
            if (null == locationInfo) {
                return;
            }
            String exceptionType = "None";
            String stackTrace = "None";
            if (null != errorInfo) {
                exceptionType = errorInfo.getThrowable().getClass().getName();
                Throwable throwable = errorInfo.getThrowable();
                if (throwable != null) {
                    StringWriter buf = new StringWriter();
                    throwable.printStackTrace(new PrintWriter(buf));
                    stackTrace = buf.toString();
                    if (stackTrace.length() > this.maxStackTraceLength) {
                        stackTrace.substring(0, this.maxStackTraceLength);
                    }
                }
            }
            String methodName = this.getMethodName(event);
            LogItemKey logInfoKey = new LogItemKey(exceptionType, methodName);
            LogItemValue logInfoStat = (LogItemValue)this.log4jDataManager.getLogMap().get(logInfoKey);
            if (null == logInfoStat) {
                logInfoStat = new LogItemValue(logInfoKey);
                this.log4jDataManager.getLogMap().put(logInfoKey, logInfoStat);
            }
            logInfoStat.incrementCount();
            logInfoStat.setLastMessage(String.valueOf(event.getMessage()));
            logInfoStat.setLastStackTrace(stackTrace);
        }
        catch (Throwable e) {
            LogLog.error((String)("monitorAppender error:" + e.getMessage()), (Throwable)e);
        }
    }

    public String getMethodName(LoggingEvent event) {
        String methodName = null;
        LocationInfo locationInfo = event.getLocationInformation();
        methodName = "?".equals(locationInfo.getClassName()) ? event.getLoggerName() : locationInfo.getClassName() + "." + locationInfo.getMethodName();
        return methodName;
    }

    public void close() {
        this.closed = true;
    }

    public boolean requiresLayout() {
        return false;
    }

    public void setEnableNoStackTrace(boolean enableNoStackTrace) {
        this.enableNoStackTrace = enableNoStackTrace;
    }

    public void setMaxStackTraceLength(int maxStackTraceLength) {
        if (maxStackTraceLength < 0) {
            return;
        }
        if (maxStackTraceLength > 10000) {
            return;
        }
        this.maxStackTraceLength = maxStackTraceLength;
    }

    public void setMaxCount(int maxCount) {
        if (maxCount <= 0) {
            return;
        }
        this.maxCount = maxCount;
    }

    static {
        FileUtils.appendToLog("cn.jmonitor.monitor4j.plugin.log4j.JMonitorLog4jAppender started.");
    }
}

