/*
 * Decompiled with CFR 0.152.
 */
package cn.jmonitor.monitor4j.plugin.jvm;

import cn.jmonitor.monitor4j.plugin.jvm.JVMThreadMBean;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.math.BigDecimal;
import java.math.MathContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JVMThread
implements JVMThreadMBean {
    private static final Log LOG = LogFactory.getLog(JVMThread.class);
    private volatile long lastCPUTime;
    private volatile long lastCPUUpTime;
    private OperatingSystemMXBean OperatingSystem;
    private RuntimeMXBean Runtime;
    private static JVMThread instance = new JVMThread();
    private ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();

    public static JVMThread getInstance() {
        return instance;
    }

    private JVMThread() {
        this.OperatingSystem = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        this.Runtime = ManagementFactory.getRuntimeMXBean();
        try {
            this.lastCPUTime = this.OperatingSystem.getProcessCpuTime();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public BigDecimal getProcessCpuTimeRate() {
        long cpuTime = this.OperatingSystem.getProcessCpuTime();
        long upTime = this.Runtime.getUptime();
        long elapsedCpu = cpuTime - this.lastCPUTime;
        long elapsedTime = upTime - this.lastCPUUpTime;
        this.lastCPUTime = cpuTime;
        this.lastCPUUpTime = upTime;
        if (elapsedTime <= 0L) {
            return new BigDecimal(0);
        }
        float cpuUsage = (float)elapsedCpu / ((float)elapsedTime * 10000.0f);
        BigDecimal cpuRate = new BigDecimal(cpuUsage, new MathContext(4));
        return cpuRate;
    }

    @Override
    public int getDaemonThreadCount() {
        return this.threadMXBean.getDaemonThreadCount();
    }

    @Override
    public int getThreadCount() {
        return this.threadMXBean.getThreadCount();
    }

    @Override
    public long getTotalStartedThreadCount() {
        return this.threadMXBean.getTotalStartedThreadCount();
    }

    @Override
    public int getDeadLockedThreadCount() {
        try {
            long[] deadLockedThreadIds = this.threadMXBean.findDeadlockedThreads();
            if (deadLockedThreadIds == null) {
                return 0;
            }
            return deadLockedThreadIds.length;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

