/*
 * Decompiled with CFR 0.152.
 */
package cn.jmonitor.monitor4j.plugin.ip;

import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.JMException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class WebIPItem {
    private String ip;
    private final AtomicInteger runningCount = new AtomicInteger();
    private final AtomicInteger concurrentMax = new AtomicInteger();
    private final AtomicLong count = new AtomicLong(0L);
    private final AtomicLong errorCount = new AtomicLong();
    private final AtomicLong nanoTotal = new AtomicLong(0L);
    private final AtomicLong nanoMax = new AtomicLong(0L);
    private String lastErrorMessage = "";
    private Date lastErrorTime;
    private static CompositeType COMPOSITE_TYPE = null;

    public WebIPItem(String ip) {
        this.ip = ip;
    }

    public void incrementRunningCount() {
        this.runningCount.incrementAndGet();
        this.count.incrementAndGet();
    }

    public void handleAfter(long startNano, boolean error, String errorMsg) {
        long nanoMaxNow;
        long nanoUseNow;
        int concurrentMaxNow;
        int runningCountNow = this.getRunningCount();
        if (runningCountNow > (concurrentMaxNow = this.getConcurrentMax())) {
            this.concurrentMax.compareAndSet(concurrentMaxNow, runningCountNow);
        }
        if ((nanoUseNow = System.nanoTime() - startNano) > (nanoMaxNow = this.getNanoMax())) {
            this.nanoMax.compareAndSet(nanoMaxNow, nanoUseNow);
        }
        this.runningCount.decrementAndGet();
        this.nanoTotal.addAndGet(nanoUseNow);
        if (error) {
            this.errorCount.incrementAndGet();
            this.lastErrorMessage = errorMsg;
            this.lastErrorTime = new Date();
        }
    }

    public int getRunningCount() {
        return this.runningCount.get();
    }

    public int getConcurrentMax() {
        return this.concurrentMax.get();
    }

    public long getCount() {
        return this.count.get();
    }

    public long getErrorCount() {
        return this.errorCount.get();
    }

    public long getNanoTotal() {
        return this.nanoTotal.get();
    }

    public long getNanoMax() {
        return this.nanoMax.get();
    }

    public String getLastErrorMessage() {
        return this.lastErrorMessage;
    }

    public Date getLastErrorTime() {
        return this.lastErrorTime;
    }

    public String getIp() {
        return this.ip;
    }

    public static CompositeType getCompositeType() throws JMException {
        String[] indexNames;
        if (COMPOSITE_TYPE != null) {
            return COMPOSITE_TYPE;
        }
        OpenType[] indexTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.STRING, SimpleType.DATE};
        String[] indexDescriptions = indexNames = new String[]{"IP", "RunningCount", "ConcurrentMax", "Count", "ErrorCount", "NanoTotal", "NanoMax", "LastErrorMessage", "LastErrorTime"};
        COMPOSITE_TYPE = new CompositeType("IPStatistic", "IP Statistic", indexNames, indexDescriptions, indexTypes);
        return COMPOSITE_TYPE;
    }

    public CompositeData getCompositeData() throws JMException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IP", this.getIp());
        map.put("RunningCount", this.getRunningCount());
        map.put("ConcurrentMax", this.getConcurrentMax());
        map.put("Count", this.getCount());
        map.put("ErrorCount", this.getErrorCount());
        map.put("NanoTotal", this.getNanoTotal());
        map.put("NanoMax", this.getNanoMax());
        map.put("LastErrorMessage", this.getLastErrorMessage());
        map.put("LastErrorTime", this.getLastErrorTime());
        return new CompositeDataSupport(WebIPItem.getCompositeType(), map);
    }
}

