/*
 * Decompiled with CFR 0.152.
 */
package cn.jmonitor.monitor4j.jmx;

import cn.jmonitor.monitor4j.client.protocal.message.GetAttribute;
import cn.jmonitor.monitor4j.plugin.ip.WebIPDataManager;
import cn.jmonitor.monitor4j.plugin.jvm.JVMGC;
import cn.jmonitor.monitor4j.plugin.jvm.JVMInfo;
import cn.jmonitor.monitor4j.plugin.jvm.JVMMemory;
import cn.jmonitor.monitor4j.plugin.jvm.JVMThread;
import cn.jmonitor.monitor4j.plugin.log4j.Log4jDataManager;
import cn.jmonitor.monitor4j.plugin.spring.SpringMethodDataManager;
import cn.jmonitor.monitor4j.plugin.web.WebUrlDataManager;
import cn.jmonitor.monitor4j.plugin.web.profile.WebUrlProfileDataManager;
import cn.jmonitor.monitor4j.utils.FileUtils;
import cn.jmonitor.monitor4j.utils.StringUtils;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMXUtils {
    private static final Log LOG = LogFactory.getLog(JMXUtils.class);
    private static MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
    private static final String JmxListAttributeName = "JmonitorDataList";

    public static void regMbean() throws Exception {
        JMXUtils.unregMbean();
        ObjectName jvmInfoName = new ObjectName("cn.jmonitor.monitor4j:type=JVMInfo");
        ObjectName jvmMemoryName = new ObjectName("cn.jmonitor.monitor4j:type=JVMMemory");
        ObjectName jvmGCName = new ObjectName("cn.jmonitor.monitor4j:type=JVMGC");
        ObjectName jvmThreadName = new ObjectName("cn.jmonitor.monitor4j:type=JVMThread");
        ObjectName exceptionName = new ObjectName("cn.jmonitor.monitor4j:type=Exception");
        ObjectName springMethodName = new ObjectName("cn.jmonitor.monitor4j:type=SpringMethod");
        ObjectName webUrlName = new ObjectName("cn.jmonitor.monitor4j:type=WebUrl");
        ObjectName webUrlProfileName = new ObjectName("cn.jmonitor.monitor4j:type=WebUrlProfile");
        ObjectName webIPName = new ObjectName("cn.jmonitor.monitor4j:type=WebIP");
        mbeanServer.registerMBean(JVMInfo.getInstance(), jvmInfoName);
        mbeanServer.registerMBean(JVMMemory.getInstance(), jvmMemoryName);
        mbeanServer.registerMBean(JVMGC.getInstance(), jvmGCName);
        mbeanServer.registerMBean(JVMThread.getInstance(), jvmThreadName);
        mbeanServer.registerMBean(Log4jDataManager.getInstance(), exceptionName);
        mbeanServer.registerMBean(SpringMethodDataManager.getInstance(), springMethodName);
        mbeanServer.registerMBean(WebUrlDataManager.getInstance(), webUrlName);
        mbeanServer.registerMBean(WebUrlProfileDataManager.getInstance(), webUrlProfileName);
        mbeanServer.registerMBean(WebIPDataManager.getInstance(), webIPName);
        FileUtils.appendToLog("reg mbeans success.");
    }

    public static void unregMbean() throws Exception {
        ObjectName jvmInfoName = new ObjectName("cn.jmonitor.monitor4j:type=JVMInfo");
        ObjectName jvmMemoryName = new ObjectName("cn.jmonitor.monitor4j:type=JVMMemory");
        ObjectName jvmGCName = new ObjectName("cn.jmonitor.monitor4j:type=JVMGC");
        ObjectName jvmThreadName = new ObjectName("cn.jmonitor.monitor4j:type=JVMThread");
        ObjectName exceptionName = new ObjectName("cn.jmonitor.monitor4j:type=Exception");
        ObjectName springMethodName = new ObjectName("cn.jmonitor.monitor4j:type=SpringMethod");
        ObjectName webUrlName = new ObjectName("cn.jmonitor.monitor4j:type=WebUrl");
        ObjectName webUrlProfileName = new ObjectName("cn.jmonitor.monitor4j:type=WebUrlProfile");
        ObjectName webIPName = new ObjectName("cn.jmonitor.monitor4j:type=WebIP");
        ObjectName sqlName = new ObjectName("cn.jmonitor.monitor4j:type=DruidSql");
        ArrayList<ObjectName> objectNameList = new ArrayList<ObjectName>();
        objectNameList.add(jvmInfoName);
        objectNameList.add(jvmMemoryName);
        objectNameList.add(jvmGCName);
        objectNameList.add(jvmThreadName);
        objectNameList.add(exceptionName);
        objectNameList.add(springMethodName);
        objectNameList.add(webUrlName);
        objectNameList.add(webUrlProfileName);
        objectNameList.add(webIPName);
        objectNameList.add(sqlName);
        for (ObjectName objectName : objectNameList) {
            if (!mbeanServer.isRegistered(objectName)) continue;
            mbeanServer.unregisterMBean(objectName);
        }
    }

    private static Map<String, Object> getAttribute(GetAttribute getAttribute) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (null == getAttribute || StringUtils.isBlank(getAttribute.getObjectName()) || null == getAttribute.getAttributeNames()) {
            return result;
        }
        try {
            List<String> attributeNames = getAttribute.getAttributeNames();
            List<String> options = getAttribute.getOptions();
            ObjectName objectName = new ObjectName(getAttribute.getObjectName());
            for (String attributeName : attributeNames) {
                try {
                    ArrayList value = mbeanServer.getAttribute(objectName, attributeName);
                    if (value instanceof TabularDataSupport) {
                        ArrayList list = new ArrayList();
                        TabularDataSupport tabularDataSupport = (TabularDataSupport)((Object)value);
                        for (Object itemValue : tabularDataSupport.values()) {
                            if (!(itemValue instanceof CompositeData)) continue;
                            CompositeData compositeData = (CompositeData)itemValue;
                            HashMap<String, Object> singleLine = new HashMap<String, Object>();
                            for (String key : compositeData.getCompositeType().keySet()) {
                                Object entryValue = compositeData.get(key);
                                singleLine.put(key, entryValue);
                            }
                            list.add(singleLine);
                        }
                        value = list;
                    }
                    result.put(attributeName, value);
                }
                catch (Exception exception) {}
            }
            if (null != options) {
                for (String option : options) {
                    if (!"reset=true".equals(option)) continue;
                    mbeanServer.invoke(objectName, "reset", null, null);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage());
        }
        return result;
    }

    public static Object getAttributeFormatted(GetAttribute getAttribute) {
        Map<String, Object> map = JMXUtils.getAttribute(getAttribute);
        if (null != map.get(JmxListAttributeName)) {
            return map.get(JmxListAttributeName);
        }
        return map;
    }
}

