/*
 * Decompiled with CFR 0.152.
 */
package cn.jmonitor.monitor4j.common;

import cn.jmonitor.monitor4j.client.JmonitorClient;
import cn.jmonitor.monitor4j.common.JmonitorConstants;
import cn.jmonitor.monitor4j.jmx.JMXUtils;
import cn.jmonitor.monitor4j.utils.FileUtils;
import cn.jmonitor.monitor4j.utils.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JmonitorBootstrap {
    private static Log LOG = LogFactory.getLog(JmonitorBootstrap.class);
    private static JmonitorBootstrap instance = new JmonitorBootstrap();
    private static boolean isStart = false;
    private static boolean isStop = false;
    private JmonitorClient client;
    private String agentHost;
    private String agentPort;
    private String appNum;
    private String enableMonitorIp;
    private String enableDruidFilter;

    private JmonitorBootstrap() {
    }

    public static JmonitorBootstrap getInstance() {
        return instance;
    }

    public static boolean isStart() {
        return isStart;
    }

    public static boolean isStop() {
        return isStop;
    }

    public synchronized void start() {
        if (isStart) {
            return;
        }
        isStart = true;
        FileUtils.appendToLog("monitor4j version:0.2");
        try {
            JMXUtils.regMbean();
            if (StringUtils.isNotBlank(this.enableMonitorIp)) {
                JmonitorConstants.enableMonitorIp = Boolean.valueOf(this.enableMonitorIp);
            }
            if (StringUtils.isNotBlank(this.enableDruidFilter)) {
                JmonitorConstants.enableDruidFilter = Boolean.valueOf(this.enableDruidFilter);
            }
            if (null == this.client) {
                this.client = new JmonitorClient();
                if (null != this.agentHost) {
                    this.client.setAgentHost(this.agentHost);
                }
                if (null != this.agentPort) {
                    this.client.setAgentPort(Integer.valueOf(this.agentPort));
                }
                if (null != this.appNum) {
                    this.client.setAppNum(this.appNum);
                }
                this.client.start();
                FileUtils.appendToLog("client start over.");
            }
        }
        catch (Exception e) {
            FileUtils.appendToLog("client start error:" + e.getMessage());
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public synchronized void stop() {
        if (isStop) {
            return;
        }
        isStop = true;
        try {
            JMXUtils.unregMbean();
            if (null != this.client) {
                this.client.stop();
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void setAgentHost(String agentHost) {
        this.agentHost = agentHost;
    }

    public void setAgentPort(String agentPort) {
        this.agentPort = agentPort;
    }

    public void setAppNum(String appNum) {
        this.appNum = appNum;
    }

    public void setEnableMonitorIp(String enableMonitorIp) {
        this.enableMonitorIp = enableMonitorIp;
    }

    public void setEnableDruidFilter(String enableDruidFilter) {
        this.enableDruidFilter = enableDruidFilter;
    }
}

