/*
 * Decompiled with CFR 0.152.
 */
package cn.jmonitor.monitor4j.client.protocal.message;

import cn.jmonitor.monitor4j.utils.JsonUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseMessage {
    protected static Log LOG = LogFactory.getLog(BaseMessage.class);
    private static final int INIT_SEQ = 1;
    private static final int MAX_SEQ = 2000000000;
    private static AtomicInteger sequenceSeed = new AtomicInteger(1);
    private int agentSequence = -1;

    public void setAgentSequence(int agentSequence) {
        this.agentSequence = agentSequence;
    }

    private int nextSequence() {
        int seq = sequenceSeed.incrementAndGet();
        while (seq >= 2000000000) {
            sequenceSeed.compareAndSet(1, seq);
            seq = sequenceSeed.incrementAndGet();
        }
        return seq;
    }

    public abstract String getType();

    public abstract boolean isRequestFormat();

    public abstract Object getBody();

    public final String buildMsg() {
        if (this.isRequestFormat()) {
            return this.buildRequestMsg();
        }
        return this.buildResponseMsg();
    }

    public final byte[] buildMsgByte() {
        byte[] result = null;
        try {
            result = this.buildMsg().getBytes("UTF-8");
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private final String buildResponseMsg() {
        Map[] msg = new Map[2];
        HashMap<String, Object> head = new HashMap<String, Object>();
        HashMap<String, Object> body = new HashMap<String, Object>();
        if (this.agentSequence != -1) {
            head.put("S", this.agentSequence);
        } else {
            head.put("S", this.nextSequence());
        }
        head.put("T", this.getType());
        body.put("TS", 0);
        body.put("VAL", this.getBody());
        msg[0] = head;
        msg[1] = body;
        return JsonUtils.toJsonString(msg);
    }

    private final String buildRequestMsg() {
        Object[] msg = new Object[2];
        HashMap<String, Object> head = new HashMap<String, Object>();
        head.put("S", this.nextSequence());
        head.put("T", this.getType());
        msg[0] = head;
        msg[1] = this.getBody();
        return JsonUtils.toJsonString(msg);
    }
}

