/*
 * Decompiled with CFR 0.152.
 */
package cn.jmonitor.monitor4j.client;

import cn.jmonitor.monitor4j.client.protocal.message.BaseMessage;
import cn.jmonitor.monitor4j.client.protocal.message.Connect;
import cn.jmonitor.monitor4j.client.protocal.message.GetAttribute;
import cn.jmonitor.monitor4j.client.protocal.message.GetAttributeResp;
import cn.jmonitor.monitor4j.client.protocal.message.Heartbeat;
import cn.jmonitor.monitor4j.client.protocal.tlv.TLVMessage;
import cn.jmonitor.monitor4j.jmx.JMXUtils;
import cn.jmonitor.monitor4j.utils.DaemonThreadFactory;
import cn.jmonitor.monitor4j.utils.FileUtils;
import cn.jmonitor.monitor4j.utils.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;

public class JmonitorClient {
    private static final Log LOG = LogFactory.getLog(JmonitorClient.class);
    private static final short TEXT_UTF_8 = 1;
    private ScheduledFuture<?> heartbeatFuture = null;
    private ScheduledFuture<?> checkFuture = null;
    private long heartbeatPeriod = 60L;
    private long checkPeriod = 60L;
    private final int maxSendCount = 100;
    private int agentPort = 19777;
    private String agentHost = "127.0.0.1";
    private String appNum;
    private AtomicInteger clientConnectErrorCount = new AtomicInteger(0);
    private BlockingQueue<BaseMessage> sendMsgQueue = new ArrayBlockingQueue<BaseMessage>(100);
    private ScheduledExecutorService heartbeatScheduler = Executors.newScheduledThreadPool(1, new DaemonThreadFactory("JmonitorClient-HeartBeat"));
    private ScheduledExecutorService checkScheduler = Executors.newScheduledThreadPool(1, new DaemonThreadFactory("JmonitorClient-CheckThread"));
    private ExecutorService writerExcutorService = Executors.newSingleThreadExecutor(new DaemonThreadFactory("JmonitorClient-WriterThread"));
    private ExecutorService readerExcutorService = Executors.newSingleThreadExecutor(new DaemonThreadFactory("JmonitorClient-ReaderThread"));
    private Socket socket;
    private DataInputStream reader;
    private DataOutputStream writer;
    private Object writerLock = new Object();
    private Object closeLock = new Object();

    public static void main(String[] args) throws Exception {
        PropertyConfigurator.configure((String)"D:/log4j.properties");
        JMXUtils.regMbean();
        JmonitorClient client = new JmonitorClient();
        client.start();
        Thread.sleep(Long.MAX_VALUE);
    }

    public void start() {
        FileUtils.appendToLog("client agentHost:" + this.agentHost);
        FileUtils.appendToLog("client agentPort:" + this.agentPort);
        FileUtils.appendToLog("client appNum:" + this.appNum);
        this.checkFuture = this.checkScheduler.scheduleWithFixedDelay(new CheckTask(), 0L, this.checkPeriod, TimeUnit.SECONDS);
        this.heartbeatFuture = this.heartbeatScheduler.scheduleAtFixedRate(new HeartTask(), 0L, this.heartbeatPeriod, TimeUnit.SECONDS);
        this.readerExcutorService.execute(new readerTask());
        this.writerExcutorService.execute(new writerTask());
    }

    public void stop() {
        if (this.heartbeatFuture != null && this.heartbeatFuture.cancel(true)) {
            this.heartbeatFuture = null;
        }
        if (this.checkFuture != null && this.checkFuture.cancel(true)) {
            this.checkFuture = null;
        }
        try {
            this.heartbeatScheduler.shutdownNow();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.checkScheduler.shutdownNow();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.writerExcutorService.shutdownNow();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.readerExcutorService.shutdownNow();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        Object object = this.closeLock;
        synchronized (object) {
            try {
                if (this.reader != null) {
                    this.reader.close();
                    this.reader = null;
                }
                if (this.writer != null) {
                    this.writer.close();
                    this.writer = null;
                }
                if (this.socket != null) {
                    this.socket.close();
                    this.socket = null;
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void handleTLVMessage(TLVMessage tlvMessage) {
        try {
            String error;
            if (null == tlvMessage) {
                return;
            }
            if (1 != tlvMessage.getType()) {
                return;
            }
            String text = new String(tlvMessage.getValue(), "UTF-8");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("read:" + text));
            }
            JSONArray array = JSONArray.parseArray((String)text);
            JSONObject header = array.getJSONObject(0);
            JSONObject body = array.getJSONObject(1);
            String type = header.getString("T");
            GetAttribute msg = null;
            if ("GetAttribute".equals(type)) {
                GetAttribute request = (GetAttribute)JSON.toJavaObject((JSON)body, GetAttribute.class);
                request.setSequence(header.getIntValue("S"));
                msg = request;
            } else if ("ConnectResp".equals(type) && StringUtils.isNotBlank(error = body.getString("ERROR"))) {
                this.clientConnectErrorCount.incrementAndGet();
            }
            if (null == msg) {
                return;
            }
            BaseMessage respMsg = this.handleMessage(msg);
            if (null == respMsg) {
                return;
            }
            this.sendMsg(respMsg);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private BaseMessage handleMessage(Object object) {
        if (null == object) {
            return null;
        }
        if (object instanceof GetAttribute) {
            GetAttribute getAttribute = (GetAttribute)object;
            Object valueMap = JMXUtils.getAttributeFormatted(getAttribute);
            GetAttributeResp attributeResp = new GetAttributeResp(valueMap);
            attributeResp.setAgentSequence(getAttribute.getSequence());
            return attributeResp;
        }
        return null;
    }

    private boolean sendMsg(BaseMessage message) {
        boolean isSuccess = false;
        if (null == message) {
            return isSuccess;
        }
        try {
            if (this.sendMsgQueue.size() >= 100) {
                this.sendMsgQueue.poll(1L, TimeUnit.SECONDS);
            }
            isSuccess = this.sendMsgQueue.offer(message, 1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        return isSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMsgDirect(BaseMessage message) throws IOException {
        Object object = this.writerLock;
        synchronized (object) {
            try {
                if (null == this.writer) {
                    return;
                }
                byte[] bytes = message.buildMsgByte();
                this.writer.writeShort(1);
                this.writer.writeInt(bytes.length);
                this.writer.write(bytes);
                this.writer.flush();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("send:" + message.buildMsg()));
                }
            }
            catch (IOException ex) {
                this.close();
                throw ex;
            }
        }
    }

    private void sendConnectMsg() throws IOException {
        Connect connectMsg = new Connect(this.appNum);
        this.sendMsgDirect(connectMsg);
    }

    public void setAppNum(String appNum) {
        this.appNum = appNum;
    }

    public void setAgentHost(String agentHost) {
        this.agentHost = agentHost;
    }

    public void setAgentPort(int agentPort) {
        this.agentPort = agentPort;
    }

    private final class writerTask
    implements Runnable {
        private writerTask() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (!Thread.interrupted()) {
                        if (null == JmonitorClient.this.writer) {
                            Thread.sleep(1000L);
                            continue;
                        }
                        BaseMessage message = (BaseMessage)JmonitorClient.this.sendMsgQueue.take();
                        if (null == message) continue;
                        JmonitorClient.this.sendMsgDirect(message);
                    }
                }
                catch (IOException e) {
                    JmonitorClient.this.close();
                    LOG.warn((Object)e.getMessage(), (Throwable)e);
                    continue;
                }
                catch (InterruptedException e) {
                    JmonitorClient.this.close();
                    LOG.warn((Object)e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    JmonitorClient.this.close();
                    LOG.warn((Object)e.getMessage(), (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    private final class readerTask
    implements Runnable {
        private readerTask() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (!Thread.interrupted()) {
                        if (null == JmonitorClient.this.reader) {
                            Thread.sleep(1000L);
                            continue;
                        }
                        short type = JmonitorClient.this.reader.readShort();
                        int length = JmonitorClient.this.reader.readInt();
                        byte[] value = new byte[length];
                        JmonitorClient.this.reader.readFully(value);
                        TLVMessage tlvMessage = new TLVMessage(type, length, value);
                        JmonitorClient.this.handleTLVMessage(tlvMessage);
                    }
                }
                catch (IOException e) {
                    JmonitorClient.this.close();
                    LOG.warn((Object)e.getMessage(), (Throwable)e);
                    continue;
                }
                catch (InterruptedException e) {
                    JmonitorClient.this.close();
                    LOG.warn((Object)e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    JmonitorClient.this.close();
                    LOG.warn((Object)e.getMessage(), (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    private final class CheckTask
    implements Runnable {
        private CheckTask() {
        }

        @Override
        public void run() {
            try {
                if (null == JmonitorClient.this.socket) {
                    JmonitorClient.this.socket = new Socket(JmonitorClient.this.agentHost, JmonitorClient.this.agentPort);
                    if (JmonitorClient.this.socket.getLocalPort() == JmonitorClient.this.agentPort) {
                        JmonitorClient.this.close();
                        return;
                    }
                    JmonitorClient.this.reader = new DataInputStream(JmonitorClient.this.socket.getInputStream());
                    JmonitorClient.this.writer = new DataOutputStream(JmonitorClient.this.socket.getOutputStream());
                    LOG.info((Object)("jmonitor connect agent success,localPort:" + JmonitorClient.this.socket.getLocalPort()));
                    FileUtils.appendToLog("jmonitor connect agent success,localPort:" + JmonitorClient.this.socket.getLocalPort());
                    JmonitorClient.this.sendConnectMsg();
                }
            }
            catch (Exception e) {
                FileUtils.appendToLog("jmonitor connect error:" + e.getMessage());
                JmonitorClient.this.close();
                LOG.error((Object)e.getMessage());
            }
        }
    }

    private final class HeartTask
    implements Runnable {
        private HeartTask() {
        }

        @Override
        public void run() {
            try {
                JmonitorClient.this.sendMsgDirect(new Heartbeat());
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

