/*
 * Copyright 2013 Alibaba.com All right reserved. This software is the
 * confidential and proprietary information of Alibaba.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with Alibaba.com.
 */
package cn.jmonitor.monitor4j.plugin.log4j;

/**
 * 用异常类型+方法名称作为key
 * 
 * @author charles 2013年12月4日 下午1:57:43
 */
public class LogItemKey {

    private String exceptionType;
    private String methodName;

    /**
     * @param exceptionType 异常类型
     * @param methodName 方法名
     */
    public LogItemKey(String exceptionType, String methodName) {
        super();
        this.exceptionType = exceptionType;
        this.methodName = methodName;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((exceptionType == null) ? 0 : exceptionType.hashCode());
        result = prime * result + ((methodName == null) ? 0 : methodName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        LogItemKey other = (LogItemKey) obj;
        if (exceptionType == null) {
            if (other.exceptionType != null)
                return false;
        } else if (!exceptionType.equals(other.exceptionType))
            return false;
        if (methodName == null) {
            if (other.methodName != null)
                return false;
        } else if (!methodName.equals(other.methodName))
            return false;
        return true;
    }

    public String getExceptionType() {
        return exceptionType;
    }

    public void setExceptionType(String exceptionType) {
        this.exceptionType = exceptionType;
    }

    public String getMethodName() {
        return methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

}
