/*
 * Decompiled with CFR 0.152.
 */
package cn.jmicro.zk.node;

import cn.jmicro.api.raft.INodeListener;
import cn.jmicro.common.util.StringUtils;
import cn.jmicro.zk.ZKDataOperator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CreateBuilder;
import org.apache.curator.framework.api.DeleteBuilder;
import org.apache.curator.framework.api.ExistsBuilder;
import org.apache.curator.framework.api.GetDataBuilder;
import org.apache.curator.framework.api.SetDataBuilder;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeManager {
    private static final Logger logger = LoggerFactory.getLogger(NodeManager.class);
    private boolean openDebug = true;
    private Map<String, Set<INodeListener>> nodeListeners = new HashMap<String, Set<INodeListener>>();
    private CuratorFramework curator = null;
    private ZKDataOperator op;
    private final Watcher watcher = event -> {
        String path = event.getPath();
        if (StringUtils.isNotEmpty((String)path)) {
            this.watchNode(path);
        }
        if (event.getType() == Watcher.Event.EventType.NodeCreated) {
            this.nodeCreate(path);
        } else if (event.getType() == Watcher.Event.EventType.NodeDeleted) {
            logger.info("NodeDeleted for path:'{}'  evnet:{}", (Object)path, (Object)event);
            this.nodeDelete(path);
        } else if (event.getType() == Watcher.Event.EventType.NodeDataChanged) {
            this.nodeDataChange(path);
        }
    };

    public NodeManager(ZKDataOperator op, CuratorFramework c, boolean openDebug) {
        this.op = op;
        this.curator = c;
        this.openDebug = openDebug;
    }

    public void connStateChange(int type) {
        if (this.nodeListeners.isEmpty()) {
            return;
        }
        if (2 == type) {
            HashSet<String> ls = new HashSet<String>();
            ls.addAll(this.nodeListeners.keySet());
            for (String path : ls) {
                this.watchNode(path);
            }
        }
    }

    private void nodeCreate(String path) {
        Set<INodeListener> lis = this.nodeListeners.get(path);
        if (lis != null && !lis.isEmpty()) {
            String str = this.op.getData(path);
            for (INodeListener l : lis) {
                l.nodeChanged(1, path, str);
            }
        }
    }

    private void nodeDataChange(String path) {
        Set<INodeListener> lis = this.nodeListeners.get(path);
        if (lis != null && !lis.isEmpty()) {
            String str = this.op.getData(path);
            for (INodeListener l : lis) {
                l.nodeChanged(3, path, str);
            }
        }
    }

    private void nodeDelete(String path) {
        Set<INodeListener> lis = this.nodeListeners.get(path);
        if (lis != null && !lis.isEmpty()) {
            for (INodeListener l : lis) {
                l.nodeChanged(2, path, null);
            }
        }
    }

    private void watchNode(String path) {
        ExistsBuilder existsBuilder = this.curator.checkExists();
        try {
            ((BackgroundPathable)existsBuilder.usingWatcher(this.watcher)).forPath(path);
        }
        catch (KeeperException.NoNodeException e) {
            logger.error(e.getMessage());
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    public void addNodeListener(String path, INodeListener lis) {
        if (this.nodeListeners.containsKey(path)) {
            Set<INodeListener> l = this.nodeListeners.get(path);
            if (this.op.existsListener(l, lis)) {
                return;
            }
            if (!l.isEmpty()) {
                l.add(lis);
                return;
            }
        }
        HashSet<INodeListener> set = new HashSet<INodeListener>();
        set.add(lis);
        this.nodeListeners.put(path, set);
        this.watchNode(path);
    }

    public void removeNodeListener(String path, INodeListener lis) {
        if (!this.nodeListeners.containsKey(path)) {
            return;
        }
        Set<INodeListener> l = this.nodeListeners.get(path);
        l.remove(lis);
    }

    public void createNode(String path, String data, int model) {
        if (data == null) {
            data = "";
        }
        if (this.exist(path)) {
            this.setData(path, data);
            return;
        }
        String[] ps = path.trim().split("/");
        String p = "";
        for (int i = 1; i < ps.length - 1; ++i) {
            if (this.exist(p = p + "/" + ps[i])) continue;
            try {
                CreateBuilder createBuilder = this.curator.create();
                createBuilder.withMode(CreateMode.PERSISTENT);
                createBuilder.forPath(p, new byte[0]);
                continue;
            }
            catch (KeeperException.NoNodeException e) {
                logger.error(e.getMessage());
                continue;
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        }
        CreateBuilder createBuilder = this.curator.create();
        try {
            byte[] d = data.getBytes("UTF-8");
            CreateMode cm = CreateMode.fromFlag((int)model);
            createBuilder.withMode(cm);
            createBuilder.forPath(path, d);
        }
        catch (KeeperException.NoNodeException e) {
            logger.error(e.getMessage());
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    public void createNode(String path, String data, boolean elp) {
        this.createNode(path, data, elp ? 1 : 0);
    }

    public boolean exist(String path) {
        ExistsBuilder existsBuilder = this.curator.checkExists();
        try {
            Stat stat = (Stat)existsBuilder.forPath(path);
            if (this.openDebug && stat == null) {
                logger.debug("Path not found: {}", (Object)path);
            }
            return stat != null;
        }
        catch (KeeperException.NoNodeException e) {
            logger.error(e.getMessage());
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return false;
    }

    public String getData(String path) {
        GetDataBuilder getDataBuilder = this.curator.getData();
        try {
            byte[] data = (byte[])getDataBuilder.forPath(path);
            if (data != null) {
                return new String(data, "UTF-8");
            }
            return "";
        }
        catch (KeeperException.NoNodeException e) {
            logger.error(e.getMessage());
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return "";
    }

    public void setData(String path, String data) {
        SetDataBuilder setDataBuilder = this.curator.setData();
        try {
            byte[] d = data.getBytes("UTF-8");
            setDataBuilder.forPath(path, d);
        }
        catch (KeeperException.NoNodeException e) {
            logger.error(e.getMessage());
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    public void deleteNode(String path) {
        DeleteBuilder deleteBuilder = this.curator.delete();
        try {
            deleteBuilder.forPath(path);
        }
        catch (KeeperException.NoNodeException e) {
            logger.error(e.getMessage());
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }
}

