/*
 * Decompiled with CFR 0.152.
 */
package cn.jmicro.zk.data;

import cn.jmicro.api.raft.IDataListener;
import cn.jmicro.zk.ZKDataOperator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.GetDataBuilder;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataManager {
    private static final Logger logger = LoggerFactory.getLogger(DataManager.class);
    private boolean openDebug = true;
    private Map<String, Set<IDataListener>> dataListeners = new HashMap<String, Set<IDataListener>>();
    private Object syncLocker = new Object();
    private CuratorFramework curator = null;
    private ZKDataOperator op;
    private final Watcher watcher = event -> {
        String path = event.getPath();
        if (event.getType() == Watcher.Event.EventType.NodeDataChanged) {
            this.watchData(path);
            Object object = this.syncLocker;
            synchronized (object) {
                this.dataChange(path);
            }
        }
    };

    public DataManager(ZKDataOperator op, CuratorFramework c, boolean openDebug) {
        this.op = op;
        this.curator = c;
        this.openDebug = openDebug;
    }

    public void connStateChange(int type) {
        if (this.dataListeners.isEmpty()) {
            return;
        }
        if (2 == type) {
            HashSet<String> ls = new HashSet<String>();
            ls.addAll(this.dataListeners.keySet());
            for (String path : ls) {
                this.watchData(path);
            }
        }
    }

    private void dataChange(String path) {
        String str = this.op.getData(path);
        Set<IDataListener> lis = this.dataListeners.get(path);
        if (lis != null && !lis.isEmpty()) {
            for (IDataListener l : lis) {
                l.dataChanged(path, str);
            }
        }
    }

    private void watchData(String path) {
        GetDataBuilder getDataBuilder = this.curator.getData();
        try {
            ((BackgroundPathable)getDataBuilder.usingWatcher(this.watcher)).forPath(path);
        }
        catch (KeeperException.NoNodeException e) {
            logger.error("watchData1: " + e.getMessage());
        }
        catch (Exception e) {
            logger.error("watchData2: ", (Throwable)e);
        }
    }

    public void addDataListener(String path, IDataListener lis) {
        Set<Object> l;
        if (this.dataListeners.containsKey(path)) {
            l = this.dataListeners.get(path);
            if (this.op.existsListener(l, lis)) {
                return;
            }
            if (!l.isEmpty()) {
                l.add(lis);
                return;
            }
        }
        l = new HashSet();
        this.dataListeners.put(path, l);
        l.add(lis);
        this.watchData(path);
    }

    public void removeDataListener(String path, IDataListener lis) {
        if (!this.dataListeners.containsKey(path)) {
            return;
        }
        Set<IDataListener> l = this.dataListeners.get(path);
        l.remove(lis);
    }
}

