/*
 * Decompiled with CFR 0.152.
 */
package cn.jmicro.zk.children;

import cn.jmicro.api.raft.IChildrenListener;
import cn.jmicro.common.util.StringUtils;
import cn.jmicro.zk.ZKDataOperator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.GetChildrenBuilder;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildrenManager {
    private static final Logger logger = LoggerFactory.getLogger(ChildrenManager.class);
    private boolean openDebug = true;
    private Object syncLocker = new Object();
    private Map<String, Set<String>> path2Children = new ConcurrentHashMap<String, Set<String>>();
    private Map<String, Set<IChildrenListener>> childrenListeners = new HashMap<String, Set<IChildrenListener>>();
    private CuratorFramework curator = null;
    private ZKDataOperator op;
    private final Watcher watcher = event -> {
        String path = event.getPath();
        if (event.getType() == Watcher.Event.EventType.NodeChildrenChanged) {
            this.watchChildren(path);
            Object object = this.syncLocker;
            synchronized (object) {
                this.childrenChange(path);
            }
        }
    };

    public ChildrenManager(ZKDataOperator op, CuratorFramework c, boolean openDebug) {
        this.op = op;
        this.curator = c;
        this.openDebug = openDebug;
    }

    public void connStateChange(int type) {
        if (this.childrenListeners.isEmpty()) {
            return;
        }
        if (2 == type) {
            HashSet<String> ls = new HashSet<String>();
            ls.addAll(this.childrenListeners.keySet());
            for (String path : ls) {
                this.watchChildren(path);
            }
        }
    }

    public void addChildrenListener(String path, IChildrenListener lis) {
        if (this.openDebug) {
            logger.debug("Add children listener for: {}", (Object)path);
        }
        if (this.childrenListeners.containsKey(path)) {
            Set<IChildrenListener> l = this.childrenListeners.get(path);
            if (this.op.existsListener(l, lis)) {
                return;
            }
            if (!l.isEmpty()) {
                l.add(lis);
                this.notifyChildrenAdd(lis, path);
                return;
            }
        }
        Set<String> set = this.getChildrenFromRaft(path);
        this.path2Children.put(path, set);
        HashSet<IChildrenListener> l = new HashSet<IChildrenListener>();
        l.add(lis);
        this.childrenListeners.put(path, l);
        this.watchChildren(path);
        this.notifyChildrenAdd(lis, path);
    }

    public void removeChildrenListener(String path, IChildrenListener lis) {
        if (!this.childrenListeners.containsKey(path)) {
            return;
        }
        Set<IChildrenListener> l = this.childrenListeners.get(path);
        l.remove(lis);
    }

    public Set<String> getChildren(String path, boolean fromCache) {
        Set<String> l = null;
        if (fromCache) {
            l = this.getChildrenFromCache(path);
        }
        if ((l == null || l.isEmpty()) && (l = this.getChildrenFromRaft(path)) != null && !l.isEmpty()) {
            HashSet<String> set = new HashSet<String>();
            set.addAll(l);
            this.path2Children.put(path, set);
        }
        return l;
    }

    private void childrenChange(String path) {
        Set<String> news = this.getChildrenFromRaft(path);
        Set<String> exists = this.getChildrenFromCache(path);
        HashSet<String> adds = new HashSet<String>();
        HashSet<String> removes = new HashSet<String>();
        for (String n : news) {
            if (exists.contains(n)) continue;
            adds.add(n);
        }
        for (String r : exists) {
            if (news.contains(r)) continue;
            removes.add(r);
        }
        Set<String> children = this.path2Children.get(path);
        if (children == null) {
            children = new HashSet<String>();
            this.path2Children.put(path, children);
        }
        if (!adds.isEmpty()) {
            children.addAll(adds);
        }
        if (!removes.isEmpty()) {
            children.removeAll(removes);
        }
        HashSet lis = new HashSet();
        lis.addAll(this.childrenListeners.get(path));
        if (lis != null && !lis.isEmpty()) {
            if (!adds.isEmpty()) {
                for (String a : adds) {
                    for (IChildrenListener l : lis) {
                        if (this.openDebug) {
                            logger.debug("childrenChange add path:{}, children:{}", (Object)path, (Object)a);
                        }
                        String data = this.op.getData(path + "/" + a);
                        l.childrenChanged(1, path, a, data);
                    }
                }
            }
            if (!removes.isEmpty()) {
                for (String a : removes) {
                    for (IChildrenListener l : lis) {
                        if (this.openDebug) {
                            logger.debug("childrenChange remove path:{}, children:{}", (Object)path, (Object)a);
                        }
                        l.childrenChanged(2, path, a, null);
                    }
                }
            }
        }
    }

    private void watchChildren(String path) {
        GetChildrenBuilder getChildBuilder = this.curator.getChildren();
        try {
            if (this.openDebug) {
                logger.debug("watchChildren: {}", (Object)path);
            }
            ((BackgroundPathable)getChildBuilder.usingWatcher(this.watcher)).forPath(path);
        }
        catch (KeeperException.NoNodeException e) {
            logger.error(e.getMessage());
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyChildrenAdd(IChildrenListener l, String path) {
        if (!this.path2Children.containsKey(path)) {
            return;
        }
        Object object = this.syncLocker;
        synchronized (object) {
            HashSet set = new HashSet();
            set.addAll(this.path2Children.get(path));
            for (String c : set) {
                String data = this.op.getData(path + "/" + c);
                l.childrenChanged(1, path, c, data);
            }
        }
    }

    public Set<String> getChildrenFromCache(String path) {
        if (this.path2Children.containsKey(path)) {
            HashSet<String> set = new HashSet<String>();
            set.addAll((Collection)this.path2Children.get(path));
            return set;
        }
        return Collections.EMPTY_SET;
    }

    public Set<String> getChildrenFromRaft(String path) {
        try {
            GetChildrenBuilder getChildBuilder = this.curator.getChildren();
            List l = (List)getChildBuilder.forPath(path);
            HashSet<String> set = new HashSet<String>();
            set.addAll(l);
            return set;
        }
        catch (KeeperException.NoNodeException e) {
            logger.error(e.getMessage());
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return Collections.EMPTY_SET;
    }

    public void removeCache(String path) {
        if (StringUtils.isEmpty((String)path)) {
            return;
        }
        String subNodeName = null;
        String parentPath = null;
        int idx = path.lastIndexOf("/");
        if (idx > 0) {
            subNodeName = path.substring(idx + 1, path.length());
            parentPath = path.substring(0, idx);
        }
        if (subNodeName != null && this.path2Children.containsKey(parentPath)) {
            this.path2Children.get(parentPath).remove(subNodeName);
        }
    }
}

