/*
 * Decompiled with CFR 0.152.
 */
package cn.jmicro.zk;

import cn.jmicro.api.config.Config;
import cn.jmicro.api.objectfactory.IObjectFactory;
import cn.jmicro.api.raft.IChildrenListener;
import cn.jmicro.api.raft.IConnectionStateChangeListener;
import cn.jmicro.api.raft.IDataListener;
import cn.jmicro.api.raft.IDataOperator;
import cn.jmicro.api.raft.INodeListener;
import cn.jmicro.common.CommonException;
import cn.jmicro.common.Utils;
import cn.jmicro.zk.children.ChildrenManager;
import cn.jmicro.zk.data.DataManager;
import cn.jmicro.zk.node.NodeManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKDataOperator
implements IDataOperator {
    private static final Logger logger = LoggerFactory.getLogger(ZKDataOperator.class);
    private boolean openDebug = false;
    private static ZKDataOperator ins = new ZKDataOperator();
    private boolean isInit = false;
    private CuratorFramework curator = null;
    private NodeManager nodeManager;
    private DataManager dataManager;
    private ChildrenManager childrenManager;
    private Set<IConnectionStateChangeListener> connListeners = new HashSet<IConnectionStateChangeListener>();
    private Properties propes = null;

    public static ZKDataOperator getIns() {
        return ins;
    }

    public void init0() {
        if (!Utils.formSystemPackagePermission((int)3)) {
            throw new CommonException("Permission reject to init data operator");
        }
        if (this.isInit) {
            return;
        }
        this.isInit = true;
        this.propes = new Properties();
        this.curator = this.createCuratorFramework();
        this.nodeManager = new NodeManager(this, this.curator, this.openDebug);
        this.dataManager = new DataManager(this, this.curator, this.openDebug);
        this.childrenManager = new ChildrenManager(this, this.curator, this.openDebug);
    }

    public void objectFactoryStarted(IObjectFactory of) {
        if (!Utils.formSystemPackagePermission((int)3)) {
            throw new CommonException("Permission reject to set objectfactory");
        }
        of.regist(CuratorFramework.class, (Object)this.curator);
    }

    public void removeNodeListener(String path, INodeListener lis) {
        this.nodeManager.removeNodeListener(path, lis);
    }

    public void addNodeListener(String path, INodeListener lis) {
        this.nodeManager.addNodeListener(path, lis);
    }

    public void addDataListener(String path, IDataListener lis) {
        this.dataManager.addDataListener(path, lis);
    }

    public void removeDataListener(String path, IDataListener lis) {
        this.dataManager.removeDataListener(path, lis);
    }

    public void addChildrenListener(String path, IChildrenListener lis) {
        this.childrenManager.addChildrenListener(path, lis);
    }

    public void removeChildrenListener(String path, IChildrenListener lis) {
        this.childrenManager.removeChildrenListener(path, lis);
    }

    public void addListener(IConnectionStateChangeListener lis) {
        this.connListeners.add(lis);
        if (this.curator.getState() == CuratorFrameworkState.STARTED) {
            lis.stateChanged(1);
        } else if (this.curator.getState() == CuratorFrameworkState.STOPPED) {
            lis.stateChanged(3);
        }
    }

    public void removeListener(IConnectionStateChangeListener lis) {
        if (this.connListeners.contains(lis)) {
            this.connListeners.remove(lis);
        }
    }

    public Set<String> getChildrenFromCache(String path) {
        return this.childrenManager.getChildrenFromCache(path);
    }

    public Set<String> getChildrenFromRaft(String path) {
        return this.childrenManager.getChildrenFromRaft(path);
    }

    public Set<String> getChildren(String path, boolean fromCache) {
        return this.childrenManager.getChildren(path, fromCache);
    }

    public boolean exist(String path) {
        return this.nodeManager.exist(path);
    }

    public String getData(String path) {
        if (this.nodeManager.exist(path)) {
            return this.nodeManager.getData(path);
        }
        return null;
    }

    public void setData(String path, String data) {
        if (path.startsWith("/jmicro") && !Utils.formSystemPackagePermission((int)3)) {
            throw new CommonException("Permission reject to set node data with path: " + path);
        }
        this.nodeManager.setData(path, data);
    }

    public void createNodeOrSetData(String path, String data, boolean elp) {
        if (path.startsWith("/jmicro") && !Utils.formSystemPackagePermission((int)3)) {
            throw new CommonException("Permission reject to create node with path: " + path);
        }
        this.nodeManager.createNode(path, data, elp);
    }

    public void createNodeOrSetData(String path, String data, int model) {
        if (path.startsWith("/jmicro") && !Utils.formSystemPackagePermission((int)3)) {
            throw new CommonException("Permission reject to create or set node with path: " + path);
        }
        this.nodeManager.createNode(path, data, model);
    }

    public void deleteNode(String path) {
        if (path.startsWith("/jmicro") && !Utils.formSystemPackagePermission((int)3)) {
            throw new CommonException("Permission reject to delete node with path: " + path);
        }
        this.nodeManager.deleteNode(path);
    }

    public <L> boolean existsListener(Set<L> listeners, L lis) {
        for (L l : listeners) {
            if (l != lis) continue;
            return true;
        }
        return false;
    }

    private CuratorFramework createCuratorFramework() {
        String namespace;
        Integer sessionTimeout;
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder();
        ACLProvider aclProvider = new ACLProvider(){
            private List<ACL> acl;

            public List<ACL> getDefaultAcl() {
                if (this.acl == null) {
                    ArrayList acl;
                    this.acl = acl = ZooDefs.Ids.OPEN_ACL_UNSAFE;
                }
                return this.acl;
            }

            public List<ACL> getAclForPath(String path) {
                return this.acl;
            }
        };
        builder.aclProvider(aclProvider);
        String connectString = Config.getRegistryHost();
        builder.connectString(connectString);
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(1000, 3);
        builder.retryPolicy((RetryPolicy)retryPolicy);
        if (this.propes.getProperty("sessionTimeout") != null && (sessionTimeout = Integer.valueOf(Integer.parseInt(this.propes.getProperty("sessionTimeout")))) != null) {
            builder.sessionTimeoutMs(sessionTimeout.intValue());
        }
        if ((namespace = this.propes.getProperty("namespace")) != null) {
            builder.namespace(namespace);
        }
        String schema = this.propes.getProperty("schema");
        String auth = this.propes.getProperty("auth");
        if (schema != null && auth != null) {
            builder.authorization(schema, auth.getBytes());
        }
        this.curator = builder.build();
        this.curator.getConnectionStateListenable().addListener((cf, state) -> this.stateChanged(state));
        this.curator.start();
        return this.curator;
    }

    protected void stateChanged(ConnectionState state) {
        int s = 0;
        if (state == ConnectionState.LOST) {
            s = 3;
        } else if (state == ConnectionState.CONNECTED) {
            s = 1;
        } else if (state == ConnectionState.RECONNECTED) {
            s = 2;
        }
        if (s != 0) {
            if (this.childrenManager != null) {
                this.childrenManager.connStateChange(s);
                this.nodeManager.connStateChange(s);
                this.dataManager.connStateChange(s);
            }
            for (IConnectionStateChangeListener l : this.connListeners) {
                l.stateChanged(s);
            }
        }
    }

    private void getConfig() {
    }
}

