/*
 * Decompiled with CFR 0.152.
 */
package cn.jmicro.ext.mybatis;

import cn.jmicro.api.JMicroContext;
import cn.jmicro.api.tx.ICurTxSessionFactory;
import cn.jmicro.api.tx.ITxSession;
import cn.jmicro.ext.mybatis.CurSqlSession;
import java.sql.Connection;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.TransactionIsolationLevel;

public class SqlSessionManager
implements SqlSessionFactory,
ICurTxSessionFactory {
    private SqlSessionFactory ssf;

    public SqlSessionManager(SqlSessionFactory sqlSessionFactory) {
        this.ssf = sqlSessionFactory;
    }

    public ITxSession curSession() {
        CurSqlSession s = (CurSqlSession)JMicroContext.get().getParam("txSessionKey", null);
        if (s == null) {
            s = new CurSqlSession(this.ssf.openSession(false));
            JMicroContext.get().setParam("txSessionKey", (Object)s);
        }
        return s;
    }

    public void commitAndCloseCurSession() {
        CurSqlSession s = (CurSqlSession)JMicroContext.get().getParam("txSessionKey", null);
        if (s == null) {
            return;
        }
        s.commit(false);
        s.close();
        this.remove();
    }

    public void rollbackAndCloseCurSession() {
        CurSqlSession s = (CurSqlSession)JMicroContext.get().getParam("txSessionKey", null);
        if (s == null) {
            return;
        }
        s.rollback(true);
        s.close();
        this.remove();
    }

    public void remove() {
        JMicroContext.get().removeParam("txSessionKey");
    }

    public SqlSession openSession() {
        return this.ssf.openSession();
    }

    public SqlSession openSession(boolean autoCommit) {
        return this.ssf.openSession(autoCommit);
    }

    public SqlSession openSession(Connection connection) {
        return this.ssf.openSession(connection);
    }

    public SqlSession openSession(TransactionIsolationLevel level) {
        return this.ssf.openSession(level);
    }

    public SqlSession openSession(ExecutorType execType) {
        return this.ssf.openSession(execType);
    }

    public SqlSession openSession(ExecutorType execType, boolean autoCommit) {
        return this.ssf.openSession(execType, autoCommit);
    }

    public SqlSession openSession(ExecutorType execType, TransactionIsolationLevel level) {
        return this.ssf.openSession(execType, level);
    }

    public SqlSession openSession(ExecutorType execType, Connection connection) {
        return this.ssf.openSession(execType, connection);
    }

    public Configuration getConfiguration() {
        return this.ssf.getConfiguration();
    }
}

