/*
 * Decompiled with CFR 0.152.
 */
package cn.jmicro.ext.mybatis;

import cn.jmicro.api.Holder;
import cn.jmicro.api.JMicroContext;
import cn.jmicro.api.Resp;
import cn.jmicro.api.annotation.Component;
import cn.jmicro.api.annotation.Inject;
import cn.jmicro.api.annotation.Interceptor;
import cn.jmicro.api.async.IPromise;
import cn.jmicro.api.exception.RpcException;
import cn.jmicro.api.internal.async.PromiseImpl;
import cn.jmicro.api.monitor.LG;
import cn.jmicro.api.net.AbstractInterceptor;
import cn.jmicro.api.net.IInterceptor;
import cn.jmicro.api.net.IRequest;
import cn.jmicro.api.net.IRequestHandler;
import cn.jmicro.api.registry.ServiceMethod;
import cn.jmicro.api.tx.ICurTxSessionFactory;
import cn.jmicro.api.utils.TimeUtils;
import cn.jmicro.ext.mybatis.ILocalTransactionResource;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="mybatisInterceptor", lazy=false, side="provider")
@Interceptor
public class MybatisInterceptor
extends AbstractInterceptor
implements IInterceptor {
    private static final Class<?> TAG = MybatisInterceptor.class;
    private static final Logger logger = LoggerFactory.getLogger(MybatisInterceptor.class);
    @Inject
    private ICurTxSessionFactory curSqlSessionManager;
    @Inject(required=false)
    private ILocalTransactionResource ltr;

    public IPromise<Object> intercept(IRequestHandler handler, IRequest req) throws RpcException {
        ServiceMethod sm = (ServiceMethod)JMicroContext.get().getParam("serviceMethodKey", null);
        if (sm == null || sm.getTxType() == 0) {
            return handler.onRequest(req);
        }
        Holder txOwner = new Holder((Object)false);
        Holder txid = new Holder(null);
        Holder asyP = new Holder(null);
        SqlSession s = (SqlSession)this.curSqlSessionManager.curSession();
        boolean isDebug = LG.isLoggable((int)2, (int[])new int[0]);
        long bt = TimeUtils.getCurTime((boolean)isDebug);
        try {
            IPromise pa;
            s.getConnection().setTransactionIsolation(sm.getTxIsolation());
            if (sm.getTxType() == 3) {
                Long tid = JMicroContext.get().getLong("txid", null);
                if (tid == null) {
                    if (!this.ltr.begin(sm)) {
                        throw new RpcException(req, "fail to create transaction context,, Method: " + sm.getKey().toKey(true, true, true), 3);
                    }
                    tid = JMicroContext.get().getLong("txid", null);
                    txOwner.set((Object)true);
                }
                if (tid == null) {
                    throw new RpcException(req, "transaction id not found,, Method: " + sm.getKey().toKey(true, true, true), 3);
                }
                if (!this.ltr.takePartIn(tid, sm.getTxPhase(), s)) {
                    throw new RpcException(req, "fail to take part in transaction: " + tid + ", Method: " + sm.getKey().toKey(true, true, true), 3);
                }
                txid.set((Object)tid);
            } else {
                txid.set(null);
                txOwner.set((Object)false);
            }
            IPromise p = handler.onRequest(req);
            if (sm.getTxType() == 1) {
                p.success((rst, cxt) -> {
                    Resp r;
                    boolean commit = true;
                    if (rst != null && rst instanceof Resp && (r = (Resp)rst).getCode() != 0) {
                        commit = false;
                    }
                    if (commit) {
                        s.commit(true);
                    } else {
                        s.rollback(true);
                    }
                    s.close();
                    if (isDebug) {
                        LG.log((byte)2, TAG, (String)("End tx: " + txid.get() + ", Cost: " + (TimeUtils.getCurTime((boolean)true) - bt)));
                    }
                }).fail((code, msg, cxt) -> {
                    s.rollback(true);
                    s.close();
                    LG.log((byte)5, TAG, (String)("rollback tx: " + txid.get() + ", Cost: " + (TimeUtils.getCurTime((boolean)true) - bt) + ", with error: " + msg));
                });
            } else if (sm.getTxType() == 3) {
                pa = null;
                if (((Boolean)txOwner.get()).booleanValue()) {
                    pa = new PromiseImpl();
                    asyP.set((Object)pa);
                }
                p.success((rst, cxt) -> {
                    Resp r;
                    PromiseImpl pa0 = (PromiseImpl)asyP.get();
                    if (pa0 != null) {
                        pa0.setContext(p.getContext());
                        pa0.setResult(rst);
                        pa0.setResultType(p.resultType());
                    }
                    boolean commit = true;
                    if (rst != null && rst instanceof Resp && (r = (Resp)rst).getCode() != 0) {
                        commit = false;
                        if (!commit && LG.isLoggable((int)4, (int[])new int[0])) {
                            LG.log((byte)4, TAG, (String)("Rollback transaction: " + txid.get() + ",Method: " + sm.getKey().toKey(true, true, true)));
                        }
                        if (((Boolean)txOwner.get()).booleanValue()) {
                            ((PromiseImpl)asyP.get()).setFail(r.getCode(), r.getMsg());
                        }
                    }
                    if (((Boolean)txOwner.get()).booleanValue()) {
                        if (commit) {
                            this.ownerEnd(sm, (Long)txid.get(), (PromiseImpl<Object>)pa0);
                        } else {
                            ((PromiseImpl)asyP.get()).done();
                            this.ownerEnd(sm, (Long)txid.get(), null);
                        }
                    }
                    if (!this.doVote(sm, (Long)txid.get(), commit) && asyP.get() != null) {
                        ((PromiseImpl)asyP.get()).setFail(3, "vote fail");
                        ((PromiseImpl)asyP.get()).done();
                    }
                    if (isDebug) {
                        LG.log((byte)2, TAG, (String)("End tx: " + txid.get() + ", Cost: " + (TimeUtils.getCurTime((boolean)true) - bt)));
                    }
                }).fail((code, msg, cxt) -> {
                    String msg0 = "Rollback transaction: " + txid.get() + ", Cost: " + (TimeUtils.getCurTime((boolean)true) - bt) + " with error " + msg + " ,Method: " + sm.getKey().toKey(true, true, true);
                    LG.log((byte)4, TAG, (String)msg0);
                    logger.warn(msg0);
                    this.doVote(sm, (Long)txid.get(), false);
                    if (((Boolean)txOwner.get()).booleanValue()) {
                        PromiseImpl pa0 = (PromiseImpl)asyP.get();
                        pa0.setContext(p.getContext());
                        pa0.setResult(p.getResult());
                        pa0.setResultType(p.resultType());
                        pa0.setFail(code, msg);
                        pa0.done();
                        this.ownerEnd(sm, (Long)txid.get(), null);
                    }
                });
                if (((Boolean)txOwner.get()).booleanValue()) {
                    IPromise iPromise = pa;
                    return iPromise;
                }
            }
            pa = p;
            return pa;
        }
        catch (Throwable e) {
            String msg2 = "rollback transaction " + txid.get() + ", Cost: " + (TimeUtils.getCurTime((boolean)true) - bt) + ",Method: " + sm.getKey().toKey(true, true, true);
            logger.error(msg2, e);
            LG.log((byte)5, TAG, (String)msg2, (Throwable)e);
            if (sm.getTxType() == 1) {
                this.curSqlSessionManager.rollbackAndCloseCurSession();
            } else if (sm.getTxType() == 3) {
                this.doVote(sm, (Long)txid.get(), false);
                if (((Boolean)txOwner.get()).booleanValue()) {
                    this.ownerEnd(sm, (Long)txid.get(), null);
                    if (asyP.get() != null) {
                        ((PromiseImpl)asyP.get()).setFail(3, "vote fail");
                        ((PromiseImpl)asyP.get()).done();
                    }
                }
            }
            throw new RpcException(req, e, 3);
        }
        finally {
            if (s != null) {
                this.curSqlSessionManager.remove();
            }
        }
    }

    private boolean doVote(ServiceMethod sm, Long tid, boolean commit) {
        if (tid == null) {
            LG.log((byte)5, TAG, (String)("Transaction ID is NULL,Method: " + sm.getKey().toKey(true, true, true)));
            return false;
        }
        if (!this.ltr.vote(tid, commit)) {
            LG.log((byte)5, TAG, (String)("Fail to vote txid: " + tid + ",Method: " + sm.getKey().toKey(true, true, true)));
            return false;
        }
        return true;
    }

    private void ownerEnd(ServiceMethod sm, Long tid, PromiseImpl<Object> asyP) {
        if (LG.isLoggable((int)3, (int[])new int[0])) {
            String msg = "Wait tx finish txid: " + JMicroContext.get().getLong("txid", Long.valueOf(-1L));
            LG.log((byte)3, TAG, (String)msg);
        }
        this.ltr.waitTxFinish(tid, asyP);
    }
}

