/*
 * Decompiled with CFR 0.152.
 */
package cn.jmicro.ext.mybatis;

import cn.jmicro.api.annotation.Component;
import cn.jmicro.api.config.Config;
import cn.jmicro.api.monitor.LG;
import cn.jmicro.api.objectfactory.IObjectFactory;
import cn.jmicro.api.objectfactory.IPostFactoryListener;
import cn.jmicro.common.CommonException;
import cn.jmicro.common.Utils;
import cn.jmicro.common.util.StringUtils;
import cn.jmicro.ext.mybatis.SqlSessionManager;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(lazy=false, level=99)
public class Init
implements IPostFactoryListener {
    private static final Logger logger = LoggerFactory.getLogger(Init.class);
    private IObjectFactory of;
    private SqlSessionManager sqlSessionMng;

    public void preInit(IObjectFactory of) {
        String driverUrl;
        DriverManager.setLogWriter(new PrintWriter(System.err));
        this.of = of;
        Config cfg = (Config)of.get(Config.class);
        String configLocation = cfg.getString("/mybatis/configLocation", null);
        if (StringUtils.isEmpty((String)configLocation)) {
            throw new CommonException("/mybatis/configLocation not found");
        }
        String env = cfg.getString("/mybatis/env", null);
        if (StringUtils.isEmpty((String)configLocation)) {
            env = "dev";
        }
        Map params = cfg.getParamByPattern("/mybatis/");
        Properties props = new Properties();
        props.putAll((Map<?, ?>)params);
        String driverKey = "/mybatis/jdbc.driver";
        if (params.containsKey(driverKey) && !Utils.isEmpty((String)(driverUrl = (String)params.get(driverKey)))) {
            try {
                logger.info("Load driver: " + driverUrl);
                LG.log((byte)3, Init.class, (String)("Load driver: " + driverUrl));
                ClassLoader cl = ClassLoader.getSystemClassLoader();
                cl.loadClass(driverUrl);
            }
            catch (ClassNotFoundException e) {
                logger.error("jdbc driver class not found: " + driverUrl, (Throwable)e);
                LG.log((byte)5, Init.class, (String)("jdbc driver class not found: " + driverUrl), (Throwable)e);
            }
        }
        if (LG.isLoggable((int)3, (int[])new int[0])) {
            LG.log((byte)3, Init.class, (String)("MyBatis Config: " + params.toString()));
        }
        InputStream inputStream = IPostFactoryListener.class.getResourceAsStream(configLocation);
        SqlSessionFactory sqlSessionFactory = new SqlSessionFactoryBuilder().build(inputStream, env, props);
        this.sqlSessionMng = new SqlSessionManager(sqlSessionFactory);
        of.regist(SqlSessionManager.class, (Object)this.sqlSessionMng);
        this.testConnection(this.sqlSessionMng);
        this.createMapperProxy(of, sqlSessionFactory.getConfiguration().getMapperRegistry().getMappers());
    }

    private void printDrivers() {
        Enumeration<Driver> drs = DriverManager.getDrivers();
        if (drs != null) {
            ClassLoader callerCL;
            Class<Init> caller = Init.class;
            ClassLoader classLoader = callerCL = caller != null ? caller.getClassLoader() : null;
            if (callerCL == null) {
                callerCL = Thread.currentThread().getContextClassLoader();
            }
            while (drs.hasMoreElements()) {
                Driver d = drs.nextElement();
                boolean result = false;
                Class<?> aClass = null;
                try {
                    aClass = Class.forName(d.getClass().getName(), true, callerCL);
                }
                catch (Exception ex) {
                    result = false;
                }
                result = aClass == d.getClass();
                logger.info("Driver: " + d.toString() + ", result:" + result + ",cl: " + d.getClass().getClassLoader().getClass().getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConnection(SqlSessionManager sqlSessionMng2) {
        try (SqlSession s = null;){
            s = this.sqlSessionMng.openSession(false);
            Statement st = s.getConnection().createStatement();
            boolean succ = st.execute("select version()");
            if (!succ) {
                logger.error("test connection fail");
                LG.log((byte)5, Init.class, (String)"test connection fail");
            }
        }
    }

    private void createMapperProxy(IObjectFactory of, Collection<Class<?>> mappers) {
        if (mappers == null || mappers.isEmpty()) {
            return;
        }
        for (Class<?> cls : mappers) {
            if (!cls.isInterface()) {
                logger.error("cls [" + cls.getName() + "] must be interface");
                continue;
            }
            Object m = this.createMapperProxy(cls);
            if (m == null) continue;
            of.regist(cls, m);
        }
    }

    private Object createMapperProxy(Class<?> cls) {
        return Proxy.newProxyInstance(Init.class.getClassLoader(), new Class[]{cls}, (InvocationHandler)new MapperProxy(cls));
    }

    public void afterInit(IObjectFactory of) {
    }

    public int runLevel() {
        return 0;
    }

    private class MapperProxy
    implements InvocationHandler {
        private Class<?> targetCls;
        private Object obj = new Object();

        public MapperProxy(Class<?> targetCls) {
            this.targetCls = targetCls;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                return method.invoke(this.obj, args);
            }
            SqlSession sqlSession = (SqlSession)Init.this.sqlSessionMng.curSession();
            Object mapper = sqlSession.getMapper(method.getDeclaringClass());
            Method m = mapper.getClass().getMethod(method.getName(), method.getParameterTypes());
            Object result = m.invoke(mapper, args);
            return result;
        }
    }
}

