/*
 * Decompiled with CFR 0.152.
 */
package cn.jmicro.ext.mongodb;

import cn.jmicro.api.annotation.Component;
import cn.jmicro.api.config.Config;
import cn.jmicro.api.objectfactory.IObjectFactory;
import cn.jmicro.api.objectfactory.IPostFactoryListener;
import cn.jmicro.common.util.StringUtils;
import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoDatabase;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PojoCodecProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(lazy=false, level=99)
public class MongodbInit
implements IPostFactoryListener {
    private static final Logger logger = LoggerFactory.getLogger(MongodbInit.class);

    public void init() {
    }

    public void preInit(IObjectFactory of) {
        Config cfg = (Config)of.get(Config.class);
        String host = cfg.getString("/mongodb/host", "localhost");
        int port = cfg.getInt("/mongodb/port", 27017);
        String username = cfg.getString("/mongodb/username", "");
        String password = cfg.getString("/mongodb/password", null);
        String dbname = cfg.getString("/mongodb/dbname", "jmicrodb");
        MongoClientOptions mongoClientOptions = MongoClientOptions.builder().build();
        MongoCredential mongoCredential = null;
        mongoCredential = StringUtils.isNotEmpty((String)username) ? MongoCredential.createScramSha1Credential((String)username, (String)dbname, (char[])(password != null ? password.toCharArray() : null)) : MongoCredential.createMongoX509Credential();
        ServerAddress serverAddress = new ServerAddress(host, port);
        MongoClient client = new MongoClient(serverAddress, mongoCredential, mongoClientOptions);
        MongoDatabase mdb = client.getDatabase(dbname);
        CodecRegistry pojoCodecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClientSettings.getDefaultCodecRegistry(), CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{PojoCodecProvider.builder().automatic(true).build()})});
        mdb = mdb.withCodecRegistry(pojoCodecRegistry);
        DB db = client.getDB(dbname);
        of.regist(MongoClient.class, (Object)client);
        of.regist(MongoDatabase.class, (Object)mdb);
        of.regist(DB.class, (Object)db);
        logger.info("Mongodb connected successfully!");
    }

    public void afterInit(IObjectFactory of) {
    }

    public int runLevel() {
        return 0;
    }
}

