/*
 * Decompiled with CFR 0.152.
 */
package cn.jmicro.ext.mongodb;

import cn.jmicro.api.annotation.Component;
import cn.jmicro.api.annotation.Inject;
import cn.jmicro.api.persist.IObjectStorage;
import cn.jmicro.api.utils.TimeUtils;
import cn.jmicro.common.util.JsonUtils;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.json.JsonWriterSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class MongodbBaseObjectStorage
implements IObjectStorage {
    private static final Logger logger = LoggerFactory.getLogger(MongodbBaseObjectStorage.class);
    private JsonWriterSettings settings = JsonWriterSettings.builder().int64Converter((value, writer) -> writer.writeNumber(value.toString())).build();
    @Inject
    private MongoDatabase mdb;
    private Object syncLocker = new Object();
    private ReentrantLock addLocker = new ReentrantLock();
    private ReentrantLock updateLocker = new ReentrantLock();
    private long lastAddTime = TimeUtils.getCurTime();
    private long lastUpdateTime = TimeUtils.getCurTime();
    private int maxCacheSize = 100;
    private long timeout = 3000L;
    private Map<String, SaveOp> saves = new HashMap<String, SaveOp>();
    private Map<String, SaveOp> tempAdds = new HashMap<String, SaveOp>();
    private Map<String, List<Document>> updates = new HashMap<String, List<Document>>();
    private Map<String, List<Document>> tempUpdates = new HashMap<String, List<Document>>();
    private AtomicInteger addCnt = new AtomicInteger(0);
    private AtomicInteger updateCnt = new AtomicInteger(0);

    public void ready() {
        new Thread(this::doWork).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWork() {
        while (true) {
            try {
                while (true) {
                    boolean ls;
                    if (this.saves.isEmpty() && this.updates.isEmpty()) {
                        Object object = this.syncLocker;
                        synchronized (object) {
                            try {
                                this.syncLocker.wait(this.timeout);
                            }
                            catch (InterruptedException e) {
                                logger.error("", (Throwable)e);
                            }
                        }
                    }
                    long curTime = TimeUtils.getCurTime();
                    if (!this.saves.isEmpty() && (this.addCnt.get() > this.maxCacheSize || curTime - this.lastAddTime > this.timeout) && (ls = this.addLocker.tryLock())) {
                        try {
                            this.addCnt.set(0);
                            this.tempAdds.putAll(this.saves);
                            this.saves.clear();
                        }
                        finally {
                            if (ls) {
                                this.addLocker.unlock();
                            }
                        }
                        if (!this.tempAdds.isEmpty()) {
                            for (Map.Entry<String, SaveOp> entry : this.tempAdds.entrySet()) {
                                entry.getValue().coll.insertMany(entry.getValue().vals);
                            }
                            this.tempAdds.clear();
                        }
                        this.lastAddTime = curTime;
                    }
                    if (this.updates.isEmpty() || this.updateCnt.get() <= this.maxCacheSize && curTime - this.lastUpdateTime <= this.timeout || !(ls = this.updateLocker.tryLock())) continue;
                    try {
                        this.updateCnt.set(0);
                        this.tempUpdates.putAll(this.updates);
                        this.updates.clear();
                    }
                    finally {
                        if (ls) {
                            this.updateLocker.unlock();
                        }
                    }
                    if (!this.tempUpdates.isEmpty()) {
                        for (Map.Entry<String, Object> entry : this.tempUpdates.entrySet()) {
                            MongoCollection coll = this.mdb.getCollection(entry.getKey());
                            for (Document o : (List)entry.getValue()) {
                                this.updateOneById((MongoCollection<Document>)coll, o, curTime);
                            }
                        }
                        this.tempUpdates.clear();
                    }
                    this.lastUpdateTime = curTime;
                }
            }
            catch (Throwable e) {
                logger.error("", e);
                continue;
            }
            break;
        }
    }

    private boolean updateOneById(MongoCollection<Document> coll, Document d, long curTime) {
        Document filter = new Document();
        try {
            if (d.containsKey((Object)"id")) {
                filter.put("id", (Object)d.getLong((Object)"id"));
            } else {
                filter.put("_id", (Object)d.getLong((Object)"_id"));
            }
        }
        catch (Exception e) {
            filter.put("_id", (Object)d.getObjectId((Object)"_id"));
        }
        Document update = new Document();
        if (!d.containsKey((Object)"updatedTime")) {
            d.put("updatedTime", (Object)curTime);
        }
        if (!d.containsKey((Object)"createdTime")) {
            d.put("createdTime", (Object)curTime);
        }
        update.put("$set", (Object)d);
        UpdateResult ur = coll.updateOne((Bson)filter, (Bson)update, new UpdateOptions().upsert(true));
        return ur.getModifiedCount() != 0L;
    }

    private <T> void doSave(String table, List<T> batchAdds, Class<T> targetClass) {
        this.mdb.getCollection(table, targetClass).insertMany(batchAdds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> boolean save(String table, List<T> val, Class<T> cls, boolean async, boolean toDocument) {
        if (val == null || val.isEmpty()) {
            return false;
        }
        MongoCollection coll = null;
        List<T> lis = val;
        if (toDocument) {
            lis = new ArrayList<T>();
            for (T v : val) {
                lis.add(this.toDocument(v));
            }
            coll = this.mdb.getCollection(table);
        } else {
            coll = this.mdb.getCollection(table, cls);
        }
        if (async) {
            boolean ls = this.addLocker.tryLock();
            if (ls) {
                try {
                    if (!this.saves.containsKey(table)) {
                        this.createOp(table, cls, coll);
                    }
                    this.saves.get(table).addAll(lis);
                    this.addCnt.addAndGet(val.size());
                }
                finally {
                    if (ls) {
                        this.addLocker.unlock();
                    }
                }
            }
            if (ls) {
                Object object = this.syncLocker;
                synchronized (object) {
                    this.syncLocker.notify();
                }
            }
        } else {
            coll.insertMany(lis);
        }
        return true;
    }

    private void createOp(String table, Class<?> cls, MongoCollection coll) {
        SaveOp op = new SaveOp();
        op.cls = cls;
        op.coll = coll;
        op.vals = new ArrayList();
        this.saves.put(table, op);
    }

    private Document toDocument(Object val) {
        Document d = null;
        d = val instanceof Document ? (Document)val : Document.parse((String)JsonUtils.getIns().toJson(val));
        if (d.containsKey((Object)"id")) {
            try {
                d.put("id", (Object)new Long(d.getInteger((Object)"id").intValue()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!d.containsKey((Object)"updatedTime")) {
            d.put("updatedTime", (Object)TimeUtils.getCurTime());
        }
        if (!d.containsKey((Object)"createdTime")) {
            d.put("createdTime", (Object)TimeUtils.getCurTime());
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> boolean save(String table, T val, Class<T> cls, boolean async, boolean toDocument) {
        if (val == null) {
            return false;
        }
        MongoCollection coll = null;
        Object v = val;
        if (toDocument) {
            v = this.toDocument(val);
            coll = this.mdb.getCollection(table);
        } else {
            coll = this.mdb.getCollection(table, cls);
        }
        if (async) {
            boolean ls = this.addLocker.tryLock();
            if (ls) {
                try {
                    if (!this.saves.containsKey(table)) {
                        this.createOp(table, cls, coll);
                    }
                    this.addCnt.incrementAndGet();
                    this.saves.get(table).add(v);
                }
                finally {
                    if (ls) {
                        this.addLocker.unlock();
                    }
                }
            }
            if (ls) {
                Object object = this.syncLocker;
                synchronized (object) {
                    this.syncLocker.notify();
                }
            }
        } else {
            coll.insertOne(v);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> boolean save(String table, T[] vals, Class<T> cls, boolean async, boolean toDocument) {
        if (vals == null || vals.length == 0) {
            return false;
        }
        long curTime = TimeUtils.getCurTime();
        MongoCollection coll = null;
        List<T> lis = Arrays.asList(vals);
        if (toDocument) {
            lis = new ArrayList<T>();
            for (int i = 0; i < vals.length; ++i) {
                lis.add(this.toDocument(vals[i]));
            }
            coll = this.mdb.getCollection(table);
        } else {
            coll = this.mdb.getCollection(table, cls);
        }
        if (async) {
            boolean ls = this.addLocker.tryLock();
            if (ls) {
                try {
                    if (!this.saves.containsKey(table)) {
                        this.createOp(table, cls, coll);
                    }
                    this.addCnt.incrementAndGet();
                    this.saves.get(table).addAll(lis);
                }
                finally {
                    if (ls) {
                        this.addLocker.unlock();
                    }
                }
            }
            if (ls) {
                Object object = this.syncLocker;
                synchronized (object) {
                    this.syncLocker.notify();
                }
            }
        } else {
            coll.insertMany(lis);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> boolean updateById(String table, T val, Class<T> targetClass, String idName, boolean async) {
        Document d = null;
        d = val instanceof Document ? (Document)val : Document.parse((String)JsonUtils.getIns().toJson(val));
        if (async) {
            boolean ls = this.updateLocker.tryLock();
            if (ls) {
                try {
                    this.updateCnt.incrementAndGet();
                    if (!this.updates.containsKey(table)) {
                        this.updates.put(table, new ArrayList());
                    }
                    this.updates.get(table).add(d);
                }
                finally {
                    if (ls) {
                        this.updateLocker.unlock();
                    }
                }
                Object object = this.syncLocker;
                synchronized (object) {
                    this.syncLocker.notify();
                }
            }
            return true;
        }
        MongoCollection coll = this.mdb.getCollection(table);
        return this.updateOneById((MongoCollection<Document>)coll, d, TimeUtils.getCurTime());
    }

    public boolean deleteById(String table, Object id, String idName) {
        MongoCollection coll = this.mdb.getCollection(table);
        Document filter = new Document();
        filter.put(idName, id);
        DeleteResult rst = coll.deleteOne((Bson)filter);
        return rst.getDeletedCount() > 0L;
    }

    public <T> Set<T> distinct(String table, String fieldName, Class<T> cls) {
        DistinctIterable rst = this.mdb.getCollection(table).distinct(fieldName, cls);
        if (rst != null) {
            HashSet l = new HashSet();
            MongoCursor ite = rst.iterator();
            while (ite.hasNext()) {
                l.add(ite.next());
            }
            return l;
        }
        return null;
    }

    public int deleteByQuery(String table, Object query) {
        Document filter = null;
        filter = query instanceof Document ? (Document)query : Document.parse((String)JsonUtils.getIns().toJson(query));
        MongoCollection coll = this.mdb.getCollection(table);
        DeleteResult dr = coll.deleteMany((Bson)filter);
        return (int)dr.getDeletedCount();
    }

    public <T> List<T> query(String table, Map<String, Object> queryConditions, Class<T> targetClass, int pageSize, int curPage) {
        Document match = this.getCondtions(queryConditions);
        FindIterable rst = this.mdb.getCollection(table).find((Bson)match, targetClass).limit(pageSize).skip(pageSize * curPage);
        ArrayList arr = new ArrayList();
        MongoCursor ite = rst.iterator();
        while (ite.hasNext()) {
            arr.add(ite.next());
        }
        return arr;
    }

    public <T> boolean updateOrSaveById(String table, T val, Class<T> cls, String tidName, boolean async) {
        if (async) {
            this.updateById(table, val, cls, tidName, true);
        } else if (!this.updateById(table, val, cls, tidName, false)) {
            return this.save(table, val, cls, false, true);
        }
        return true;
    }

    public <T> boolean update(String table, Object filter, Object updater, Class<T> targetClass) {
        Document up = null;
        if (updater instanceof Document) {
            up = (Document)updater;
        } else {
            up = new Document();
            Document up0 = Document.parse((String)JsonUtils.getIns().toJson(updater));
            if (!up0.containsKey((Object)"updatedTime")) {
                up0.put("updatedTime", (Object)TimeUtils.getCurTime());
            }
            if (!up0.containsKey((Object)"createdTime")) {
                up0.put("createdTime", (Object)TimeUtils.getCurTime());
            }
            up.put("$set", (Object)up0);
        }
        Document fi = null;
        if (filter instanceof Document) {
            fi = (Document)filter;
        } else if (filter instanceof Map) {
            fi = Document.parse((String)JsonUtils.getIns().toJson(filter));
        } else {
            fi = new Document();
            fi.put("id", (Object)Integer.parseInt(filter.toString()));
        }
        MongoCollection coll = this.mdb.getCollection(table);
        UpdateResult ur = coll.updateOne((Bson)fi, (Bson)up, new UpdateOptions().upsert(true));
        return ur.getModifiedCount() != 0L;
    }

    public <T> List<T> query(String table, Map<String, Object> queryConditions, Class<T> targetClass) {
        Document match = this.getCondtions(queryConditions);
        FindIterable rst = this.mdb.getCollection(table).find((Bson)match, targetClass);
        ArrayList arr = new ArrayList();
        MongoCursor ite = rst.iterator();
        while (ite.hasNext()) {
            arr.add(ite.next());
        }
        return arr;
    }

    public long count(String table, Map<String, Object> queryConditions) {
        Document match = this.getCondtions(queryConditions);
        MongoCollection rpcLogColl = this.mdb.getCollection(table);
        return rpcLogColl.countDocuments((Bson)match);
    }

    private Document getCondtions(Map<String, Object> queryConditions) {
        Document match = new Document();
        for (String key : queryConditions.keySet()) {
            match.put(key, queryConditions.get(key));
        }
        return match;
    }

    public <T> T getOne(String table, Map<String, Object> queryConditions, Class<T> targetClass) {
        Document match = this.getCondtions(queryConditions);
        FindIterable rst = this.mdb.getCollection(table, targetClass).find((Bson)match, targetClass);
        return (T)rst.first();
    }

    class SaveOp {
        List vals;
        Class<?> cls;
        MongoCollection<?> coll;

        SaveOp() {
        }

        void addAll(List l) {
            this.vals.addAll(l);
        }

        void add(Object obj) {
            this.vals.add(obj);
        }
    }
}

