/*
 * Decompiled with CFR 0.152.
 */
package cn.jmicro.api.tx.impl;

import cn.jmicro.api.Holder;
import cn.jmicro.api.Resp;
import cn.jmicro.api.annotation.Component;
import cn.jmicro.api.annotation.Inject;
import cn.jmicro.api.annotation.Reference;
import cn.jmicro.api.annotation.SMethod;
import cn.jmicro.api.annotation.Service;
import cn.jmicro.api.choreography.ProcessInfo;
import cn.jmicro.api.idgenerator.ComponentIdServer;
import cn.jmicro.api.mng.JmicroInstanceManager;
import cn.jmicro.api.monitor.LG;
import cn.jmicro.api.objectfactory.AbstractClientServiceProxyHolder;
import cn.jmicro.api.tx.ITransationService;
import cn.jmicro.api.tx.TxConfig;
import cn.jmicro.api.tx.TxInfo;
import cn.jmicro.api.tx.genclient.ITransactionResource;
import cn.jmicro.api.utils.TimeUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(version="0.0.1", external=false, timeout=10000, debugMode=1, showFront=true, clientId=-1, logLevel=2)
public class TransationServiceImpl
implements ITransationService {
    private static final Class<?> TAG = TransationServiceImpl.class;
    private static final Logger logger = LoggerFactory.getLogger(TransationServiceImpl.class);
    @Reference(namespace="*", version="*", type="ins", required=false, changeListener="resourceServiceChangeListener")
    private Set<ITransactionResource.JMAsyncClient> resourceServices = Collections.synchronizedSet(new HashSet());
    private Map<Integer, ITransactionResource.JMAsyncClient> rsMap = Collections.synchronizedMap(new HashMap());
    private Map<Long, TxGroup> txGroups = new HashMap<Long, TxGroup>();
    private Set<Long> finishTxids = new HashSet<Long>();
    @Inject
    private ComponentIdServer idGenerator;
    @Inject
    private JmicroInstanceManager insMng;
    @Inject
    private ProcessInfo pi;
    private Object syno = new Object();

    public void ready() {
        new Thread(this::check).start();
        if (!this.resourceServices.isEmpty()) {
            for (ITransactionResource.JMAsyncClient r : this.resourceServices) {
                this.rsMap.put(r.getItem().getInsId(), r);
            }
        }
    }

    public void resourceServiceChangeListener(AbstractClientServiceProxyHolder po, int opType) {
        if (opType == 1) {
            this.rsMap.put(po.getInsId(), (ITransactionResource.JMAsyncClient)po);
        } else if (opType == 2) {
            this.rsMap.remove(po.getInsId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void check() {
        HashSet<Long> keys = new HashSet<Long>();
        HashSet<Long> txids = new HashSet<Long>();
        while (true) {
            try {
                while (true) {
                    TxGroup txGroup;
                    TxGroup g;
                    Iterator iterator;
                    if (!this.finishTxids.isEmpty()) {
                        iterator = this.finishTxids;
                        synchronized (iterator) {
                            txids.addAll(this.finishTxids);
                            this.finishTxids.clear();
                        }
                        for (Long txid : txids) {
                            txGroup = g = this.txGroups.remove(txid);
                            synchronized (txGroup) {
                                this.finishOneGroup(g);
                            }
                        }
                        txids.clear();
                    }
                    if (this.txGroups.size() > 0) {
                        iterator = this.txGroups;
                        synchronized (iterator) {
                            keys.addAll(this.txGroups.keySet());
                        }
                        for (Long txid : keys) {
                            g = this.txGroups.get(txid);
                            if (g == null || g.cfg.getTimeout() <= 0L) continue;
                            txGroup = g;
                            synchronized (txGroup) {
                                if (TimeUtils.getCurTime() - g.startedTime < g.cfg.getTimeout()) {
                                    continue;
                                }
                                this.txGroups.remove(txid);
                                LG.log((byte)5, TAG, (String)("Transactin " + txid + " timeout with " + (TimeUtils.getCurTime() - g.startedTime) + " cfg timeout: " + g.cfg.getTimeout()));
                                this.finishOneGroup(g);
                            }
                        }
                        keys.clear();
                    }
                    iterator = this.syno;
                    synchronized (iterator) {
                        try {
                            this.syno.wait(1000L);
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }
            catch (Throwable e) {
                LG.log((byte)5, TAG, (String)"check error", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private void finishOneGroup(TxGroup g) {
        ITransactionResource.JMAsyncClient client;
        boolean commit = true;
        for (TxVoter v : g.voters.values()) {
            if (!this.rsMap.containsKey(v.pid)) {
                LG.log((byte)5, TAG, (String)("Rollback by resource client  " + v.pid + " not found for txid: " + g.txId + ",insName: " + v.insName));
                commit = false;
                break;
            }
            if (v.status == 2) continue;
            commit = false;
            break;
        }
        Holder suc = new Holder((Object)commit);
        if (commit) {
            CountDownLatch cd = new CountDownLatch(g.voters.values().size());
            for (TxVoter v : g.voters.values()) {
                if (v.txPhase == 1) {
                    cd.countDown();
                    continue;
                }
                client = this.rsMap.get(v.pid);
                if (client != null) {
                    client.canCommitJMAsync(g.txId).success((rst, cxt) -> {
                        Boolean s = (Boolean)rst.getData();
                        if (rst.getCode() != 0 || !s.booleanValue()) {
                            suc.set((Object)false);
                        }
                        cd.countDown();
                    }).fail((code, msg, cxt) -> {
                        suc.set((Object)false);
                        cd.countDown();
                        LG.log((byte)5, TAG, (String)("Fail to check commit status txid:" + g.txId + ", commit: false,insName: " + v.insName + ",code:" + code + ",msg:" + msg));
                    });
                    continue;
                }
                suc.set((Object)false);
                cd.countDown();
                if (!LG.isLoggable((int)4, null)) break;
                LG.log((byte)4, TAG, (String)("Transaction client not found when check commit status: " + v.pid + ",insName: " + v.insName));
                break;
            }
        }
        boolean succ = (Boolean)suc.get();
        for (TxVoter v : g.voters.values()) {
            client = this.rsMap.get(v.pid);
            if (client != null) {
                if (LG.isLoggable((int)2, null)) {
                    LG.log((byte)2, TAG, (String)("Notify transaction " + g.txId + " client pid:" + v.pid + ",commit: " + succ + ",insName: " + v.insName));
                }
                client.finishJMAsync(g.txId, succ).success((rst, cxt) -> {
                    if (LG.isLoggable((int)3, null)) {
                        LG.log((byte)3, TAG, (String)("Commit success " + g.txId + " client pid:" + v.pid + ",commit: " + succ + ",insName: " + v.insName));
                    }
                }).fail((code, msg, cxt) -> LG.log((byte)5, (String)"tx", (String)("fail to commit txid:" + g.txId + ", commit: " + succ + ",insName: " + v.insName + ",code:" + code + ",insId:" + v.pid + ",msg:" + msg)));
                continue;
            }
            LG.log((byte)5, (String)"tx", (String)("Client not found txid:" + g.txId + ", commit: " + succ + ",insName: " + v.insName + ",insId:" + v.pid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMethod(retryCnt=0, timeout=3000)
    public Resp<TxInfo> start(TxConfig cfg) {
        Long txid = this.idGenerator.getLongId(TxConfig.class);
        Resp r = new Resp(3, "");
        if (txid <= 0L) {
            ProcessInfo pi = this.insMng.getInstanceById(Integer.valueOf(cfg.getPid()));
            r.setMsg("create txid failure!");
            LG.log((byte)5, TAG, (String)(r.getMsg() + ",by insName: " + pi.getInstanceName()));
            return r;
        }
        if (LG.isLoggable((int)2, null)) {
            ProcessInfo pi = this.insMng.getInstanceById(Integer.valueOf(cfg.getPid()));
            LG.log((byte)2, TAG, (String)("Start transaction: " + txid + ",by insName: " + pi.getInstanceName()));
        }
        TxGroup g = new TxGroup(cfg, txid);
        Map<Long, TxGroup> map = this.txGroups;
        synchronized (map) {
            this.txGroups.put(txid, g);
        }
        TxInfo ti = new TxInfo();
        ti.setServerId(this.pi.getId());
        ti.setTxid(txid.longValue());
        r.setData((Object)ti);
        r.setCode(0);
        return r;
    }

    @SMethod(retryCnt=3, timeout=3000)
    public Resp<Boolean> takePartIn(int pid, long txid, byte txPhase) {
        Resp r = new Resp(1, (Object)false);
        ProcessInfo pi = this.insMng.getInstanceById(Integer.valueOf(pid));
        TxGroup g = this.txGroups.get(txid);
        if (g == null) {
            r.setMsg("Transaction " + txid + " not found for pid: " + pid + ",insName:" + pi.getInstanceName());
            LG.log((byte)5, TAG, (String)r.getMsg());
            return r;
        }
        if (!this.rsMap.containsKey(pid)) {
            r.setMsg("Resource client " + pid + " not found for txid: " + txid + ",insName:" + pi.getInstanceName());
            LG.log((byte)5, TAG, (String)r.getMsg());
            return r;
        }
        if (g.status != 1) {
            r.setMsg("Pid: " + pid + " Transaction " + txid + " status is not on going with status: " + g.status + ",insName:" + pi.getInstanceName());
            LG.log((byte)5, TAG, (String)r.getMsg());
            return r;
        }
        if (LG.isLoggable((int)2, (int[])new int[0])) {
            LG.log((byte)2, TAG, (String)("Resource client " + pid + " take part in txid: " + txid + ",insName:" + pi.getInstanceName()));
        }
        TxVoter v = new TxVoter(pid);
        v.insName = pi.getInstanceName();
        v.status = (byte)1;
        v.txPhase = txPhase;
        g.addVoter(v);
        r.setCode(0);
        r.setData((Object)true);
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMethod(retryCnt=0, timeout=3000)
    public Resp<Boolean> vote(int pid, long txid, boolean commit) {
        Resp r = new Resp(1, (Object)false);
        ProcessInfo pi = this.insMng.getInstanceById(Integer.valueOf(pid));
        TxGroup g = this.txGroups.get(txid);
        if (g == null) {
            r.setMsg("Transaction" + txid + " not found for pid: " + pid + ",insName:" + pi.getInstanceName());
            LG.log((byte)5, TAG, (String)r.getMsg());
            return r;
        }
        if (!this.rsMap.containsKey(pid)) {
            r.setMsg("Resource client " + pid + " not found for txid: " + txid + ",insName:" + pi.getInstanceName());
            LG.log((byte)5, TAG, (String)r.getMsg());
            return r;
        }
        if (g.status != 1) {
            r.setMsg("Pid: " + pid + " Transaction " + txid + " status is not on going with status: " + g.status + ",insName:" + pi.getInstanceName());
            LG.log((byte)5, TAG, (String)r.getMsg());
            return r;
        }
        TxVoter v = g.getVoter(pid);
        if (v == null) {
            r.setMsg("Transaction " + txid + " not found voter pid: " + pid + ",insName:" + pi.getInstanceName());
            LG.log((byte)5, TAG, (String)r.getMsg());
            return r;
        }
        if (LG.isLoggable((int)2, (int[])new int[0])) {
            LG.log((byte)2, TAG, (String)("Resource client " + pid + " vote txid: " + txid + " with: " + commit + ",insName:" + pi.getInstanceName()));
        }
        v.status = commit ? (byte)2 : 3;
        boolean fi = true;
        Object object = g;
        synchronized (object) {
            for (TxVoter tv : g.voters.values()) {
                if (tv.status != 1) continue;
                fi = false;
                break;
            }
        }
        if (fi) {
            object = this.finishTxids;
            synchronized (object) {
                this.finishTxids.add(txid);
            }
            object = this.syno;
            synchronized (object) {
                this.syno.notify();
            }
        }
        r.setCode(0);
        r.setData((Object)true);
        return r;
    }

    private class TxVoter {
        private int pid;
        private byte txPhase = 1;
        private String insName;
        private byte status = 1;

        private TxVoter(int pid) {
            this.pid = pid;
        }
    }

    private class TxGroup {
        private static final byte STATUS_ON_GOING = 1;
        private static final byte STATUS_COMMITED = 2;
        private static final byte STATUS_ROLLBACK = 3;
        private byte status = 1;
        private long txId;
        private TxConfig cfg;
        private long startedTime;
        private Map<Integer, TxVoter> voters = new HashMap<Integer, TxVoter>();

        private TxGroup(TxConfig cfg, long txId) {
            this.cfg = cfg;
            this.txId = txId;
            this.startedTime = TimeUtils.getCurTime();
        }

        private void addVoter(TxVoter v) {
            this.voters.put(v.pid, v);
        }

        private TxVoter getVoter(int pid) {
            return this.voters.get(pid);
        }
    }
}

