/*
 * Decompiled with CFR 0.152.
 */
package cn.jmicro.limit;

import cn.jmicro.api.limitspeed.ILimiter;
import cn.jmicro.api.monitor.LG;
import cn.jmicro.api.monitor.MT;
import cn.jmicro.api.net.IRequest;
import cn.jmicro.limit.AbstractLimiter;
import cn.jmicro.limit.ITokenBucket;
import cn.jmicro.limit.TokenBucket;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenBucketLimiter
extends AbstractLimiter
implements ILimiter {
    private static final Logger logger = LoggerFactory.getLogger(TokenBucketLimiter.class);
    private static final Class<?> TAG = TokenBucketLimiter.class;
    private Map<String, ITokenBucket> buckets = new HashMap<String, ITokenBucket>();

    public boolean enter(IRequest req) {
        int speed = this.getSpeed(req);
        if (speed <= 0) {
            return true;
        }
        String key = this.serviceKey(req);
        if (!this.buckets.containsKey(key)) {
            this.buckets.put(key, new TokenBucket(this.getSpeedUnit(req)));
        }
        ITokenBucket b = this.buckets.get(key);
        b.updateSpeed(speed);
        int rst = b.applyToken(1);
        if (rst < 0) {
            String errMsg = "speed:" + speed + ",key:" + key;
            LG.log((byte)4, TAG, (String)errMsg);
            MT.rpcEvent((short)12);
            logger.info(errMsg);
            return false;
        }
        return true;
    }
}

