/*
 * Decompiled with CFR 0.152.
 */
package cn.jmicro.limit;

import cn.jmicro.api.JMicroContext;
import cn.jmicro.api.annotation.Inject;
import cn.jmicro.api.limitspeed.ILimiter;
import cn.jmicro.api.monitor.ServiceCounter;
import cn.jmicro.api.net.IRequest;
import cn.jmicro.api.registry.ServiceMethod;
import cn.jmicro.api.security.AccountRelatedStatis;
import cn.jmicro.api.security.ActInfo;
import cn.jmicro.api.utils.TimeUtils;
import cn.jmicro.limit.AbstractLimiter;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSpeedLimiter
extends AbstractLimiter
implements ILimiter {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSpeedLimiter.class);
    private static final Class<?> TAG = DefaultSpeedLimiter.class;
    private static final String Act_SM_SEPERATOR = ":";
    @Inject
    private AccountRelatedStatis actStatisManager;

    public boolean enter(IRequest req) {
        ServiceMethod sm = (ServiceMethod)JMicroContext.get().getParam("serviceMethodKey", null);
        if (sm.getMaxSpeed() <= 0) {
            return true;
        }
        String key = this.counterKey(sm, req);
        ServiceCounter sc = this.actStatisManager.getCounter(key);
        sc.increment(Short.valueOf((short)1));
        double qps = sc.getQps(TimeUnit.SECONDS, new Short[]{(short)1});
        sc.setLastActiveTime(TimeUtils.getCurTime());
        if (qps > (double)sm.getMaxSpeed()) {
            logger.info("{} cur qps:{},{} maxSpeed:{}", new Object[]{key, qps, sm.getKey().toKey(false, false, false), sm.getMaxSpeed()});
            return false;
        }
        return true;
    }

    private String counterKey(ServiceMethod sm, IRequest req) {
        String key = "";
        ActInfo ai = JMicroContext.get().getAccount();
        key = ai == null ? req.getSession().remoteHost() : ai.getActName();
        return key + Act_SM_SEPERATOR + sm.getKey().toKey(false, false, false);
    }

    @Override
    public void end(IRequest req) {
    }
}

