/*
 * Decompiled with CFR 0.152.
 */
package cn.jmicro.limit;

import cn.jmicro.api.EnterMain;
import cn.jmicro.api.limitspeed.ILimiter;
import cn.jmicro.api.net.IRequest;
import cn.jmicro.api.registry.ServiceItem;
import cn.jmicro.api.registry.ServiceMethod;
import cn.jmicro.common.CommonException;
import cn.jmicro.common.util.StringUtils;
import java.util.Set;

public abstract class AbstractLimiter
implements ILimiter {
    protected String serviceKey(IRequest req) {
        String key = req.getServiceName() + req.getMethod();
        if (req.getArgs() == null || req.getArgs().length == 0) {
            return key;
        }
        for (Object o : req.getArgs()) {
            key = key + o.getClass().getName();
        }
        return key;
    }

    protected ServiceItem getServiceItem(IRequest req) {
        Set sis = EnterMain.getRegistry(null).getServices(req.getServiceName(), req.getMethod(), req.getNamespace(), req.getVersion(), req.getTransport());
        if (sis == null || sis.isEmpty()) {
            return null;
        }
        return (ServiceItem)sis.iterator().next();
    }

    protected ServiceMethod getServiceMethod(ServiceItem item, IRequest req) {
        ServiceItem si = this.getServiceItem(req);
        if (si == null) {
            throw new CommonException("Service not found: " + req.getServiceName());
        }
        ServiceMethod sm = null;
        for (ServiceMethod mi : si.getMethods()) {
            if (!mi.getKey().getMethod().equals(req.getMethod())) continue;
            sm = mi;
            break;
        }
        if (sm == null) {
            throw new CommonException("Service method not found: " + req.getServiceName() + "." + req.getMethod());
        }
        return sm;
    }

    protected String getSpeedUnit(IRequest req) {
        ServiceItem si = this.getServiceItem(req);
        if (si == null) {
            throw new CommonException("Service not found: " + req.getServiceName());
        }
        ServiceMethod sm = this.getServiceMethod(si, req);
        if (StringUtils.isEmpty((String)sm.getBaseTimeUnit())) {
            return si.getBaseTimeUnit();
        }
        return sm.getBaseTimeUnit();
    }

    protected int getSpeed(IRequest req) {
        ServiceItem si = this.getServiceItem(req);
        if (si == null) {
            throw new CommonException("Service not found: " + req.getServiceName());
        }
        ServiceMethod sm = this.getServiceMethod(si, req);
        int maxSpeed = sm.getMaxSpeed();
        if (maxSpeed == 0) {
            return 0;
        }
        if (maxSpeed < 0) {
            maxSpeed = si.getMaxSpeed();
        }
        if (maxSpeed <= 0) {
            return 0;
        }
        return maxSpeed;
    }

    public void end(IRequest req) {
    }
}

